import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatelinkEndpointServerlessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#id PrivatelinkEndpointServerless#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#instance_name PrivatelinkEndpointServerless#instance_name}
    */
    readonly instanceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#project_id PrivatelinkEndpointServerless#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#provider_name PrivatelinkEndpointServerless#provider_name}
    */
    readonly providerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#timeouts PrivatelinkEndpointServerless#timeouts}
    */
    readonly timeouts?: PrivatelinkEndpointServerlessTimeouts;
}
export interface PrivatelinkEndpointServerlessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#create PrivatelinkEndpointServerless#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless#delete PrivatelinkEndpointServerless#delete}
    */
    readonly delete?: string;
}
export declare function privatelinkEndpointServerlessTimeoutsToTerraform(struct?: PrivatelinkEndpointServerlessTimeoutsOutputReference | PrivatelinkEndpointServerlessTimeouts | cdktf.IResolvable): any;
export declare class PrivatelinkEndpointServerlessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatelinkEndpointServerlessTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatelinkEndpointServerlessTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless mongodbatlas_privatelink_endpoint_serverless}
*/
export declare class PrivatelinkEndpointServerless extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint_serverless";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_serverless mongodbatlas_privatelink_endpoint_serverless} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatelinkEndpointServerlessConfig
    */
    constructor(scope: Construct, id: string, config: PrivatelinkEndpointServerlessConfig);
    get endpointId(): string;
    get endpointServiceName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    get privateLinkServiceResourceId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    get status(): string;
    private _timeouts;
    get timeouts(): PrivatelinkEndpointServerlessTimeoutsOutputReference;
    putTimeouts(value: PrivatelinkEndpointServerlessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatelinkEndpointServerlessTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
