import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatelinkEndpointServiceServerlessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#cloud_provider_endpoint_id PrivatelinkEndpointServiceServerless#cloud_provider_endpoint_id}
    */
    readonly cloudProviderEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#comment PrivatelinkEndpointServiceServerless#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#endpoint_id PrivatelinkEndpointServiceServerless#endpoint_id}
    */
    readonly endpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#id PrivatelinkEndpointServiceServerless#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#instance_name PrivatelinkEndpointServiceServerless#instance_name}
    */
    readonly instanceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#private_endpoint_ip_address PrivatelinkEndpointServiceServerless#private_endpoint_ip_address}
    */
    readonly privateEndpointIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#project_id PrivatelinkEndpointServiceServerless#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#provider_name PrivatelinkEndpointServiceServerless#provider_name}
    */
    readonly providerName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#timeouts PrivatelinkEndpointServiceServerless#timeouts}
    */
    readonly timeouts?: PrivatelinkEndpointServiceServerlessTimeouts;
}
export interface PrivatelinkEndpointServiceServerlessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#create PrivatelinkEndpointServiceServerless#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless#delete PrivatelinkEndpointServiceServerless#delete}
    */
    readonly delete?: string;
}
export declare function privatelinkEndpointServiceServerlessTimeoutsToTerraform(struct?: PrivatelinkEndpointServiceServerlessTimeoutsOutputReference | PrivatelinkEndpointServiceServerlessTimeouts | cdktf.IResolvable): any;
export declare class PrivatelinkEndpointServiceServerlessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatelinkEndpointServiceServerlessTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatelinkEndpointServiceServerlessTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless mongodbatlas_privatelink_endpoint_service_serverless}
*/
export declare class PrivatelinkEndpointServiceServerless extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint_service_serverless";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service_serverless mongodbatlas_privatelink_endpoint_service_serverless} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatelinkEndpointServiceServerlessConfig
    */
    constructor(scope: Construct, id: string, config: PrivatelinkEndpointServiceServerlessConfig);
    private _cloudProviderEndpointId?;
    get cloudProviderEndpointId(): string;
    set cloudProviderEndpointId(value: string);
    resetCloudProviderEndpointId(): void;
    get cloudProviderEndpointIdInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _endpointId?;
    get endpointId(): string;
    set endpointId(value: string);
    get endpointIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _privateEndpointIpAddress?;
    get privateEndpointIpAddress(): string;
    set privateEndpointIpAddress(value: string);
    resetPrivateEndpointIpAddress(): void;
    get privateEndpointIpAddressInput(): string | undefined;
    get privateLinkServiceResourceId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    get status(): string;
    private _timeouts;
    get timeouts(): PrivatelinkEndpointServiceServerlessTimeoutsOutputReference;
    putTimeouts(value: PrivatelinkEndpointServiceServerlessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatelinkEndpointServiceServerlessTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
