import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatelinkEndpointServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#endpoint_service_id PrivatelinkEndpointService#endpoint_service_id}
    */
    readonly endpointServiceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#gcp_project_id PrivatelinkEndpointService#gcp_project_id}
    */
    readonly gcpProjectId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#id PrivatelinkEndpointService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#private_endpoint_ip_address PrivatelinkEndpointService#private_endpoint_ip_address}
    */
    readonly privateEndpointIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#private_link_id PrivatelinkEndpointService#private_link_id}
    */
    readonly privateLinkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#project_id PrivatelinkEndpointService#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#provider_name PrivatelinkEndpointService#provider_name}
    */
    readonly providerName: string;
    /**
    * endpoints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#endpoints PrivatelinkEndpointService#endpoints}
    */
    readonly endpoints?: PrivatelinkEndpointServiceEndpoints[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#timeouts PrivatelinkEndpointService#timeouts}
    */
    readonly timeouts?: PrivatelinkEndpointServiceTimeouts;
}
export interface PrivatelinkEndpointServiceEndpoints {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#endpoint_name PrivatelinkEndpointService#endpoint_name}
    */
    readonly endpointName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#ip_address PrivatelinkEndpointService#ip_address}
    */
    readonly ipAddress?: string;
}
export declare function privatelinkEndpointServiceEndpointsToTerraform(struct?: PrivatelinkEndpointServiceEndpoints | cdktf.IResolvable): any;
export declare class PrivatelinkEndpointServiceEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatelinkEndpointServiceEndpoints | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatelinkEndpointServiceEndpoints | cdktf.IResolvable | undefined);
    private _endpointName?;
    get endpointName(): string;
    set endpointName(value: string);
    resetEndpointName(): void;
    get endpointNameInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    get serviceAttachmentName(): string;
    get status(): string;
}
export declare class PrivatelinkEndpointServiceEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatelinkEndpointServiceEndpoints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatelinkEndpointServiceEndpointsOutputReference;
}
export interface PrivatelinkEndpointServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#create PrivatelinkEndpointService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service#delete PrivatelinkEndpointService#delete}
    */
    readonly delete?: string;
}
export declare function privatelinkEndpointServiceTimeoutsToTerraform(struct?: PrivatelinkEndpointServiceTimeoutsOutputReference | PrivatelinkEndpointServiceTimeouts | cdktf.IResolvable): any;
export declare class PrivatelinkEndpointServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatelinkEndpointServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatelinkEndpointServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service mongodbatlas_privatelink_endpoint_service}
*/
export declare class PrivatelinkEndpointService extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint_service mongodbatlas_privatelink_endpoint_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatelinkEndpointServiceConfig
    */
    constructor(scope: Construct, id: string, config: PrivatelinkEndpointServiceConfig);
    get awsConnectionStatus(): string;
    get azureStatus(): string;
    get deleteRequested(): cdktf.IResolvable;
    get endpointGroupName(): string;
    private _endpointServiceId?;
    get endpointServiceId(): string;
    set endpointServiceId(value: string);
    get endpointServiceIdInput(): string | undefined;
    get errorMessage(): string;
    private _gcpProjectId?;
    get gcpProjectId(): string;
    set gcpProjectId(value: string);
    resetGcpProjectId(): void;
    get gcpProjectIdInput(): string | undefined;
    get gcpStatus(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interfaceEndpointId(): string;
    get privateEndpointConnectionName(): string;
    private _privateEndpointIpAddress?;
    get privateEndpointIpAddress(): string;
    set privateEndpointIpAddress(value: string);
    resetPrivateEndpointIpAddress(): void;
    get privateEndpointIpAddressInput(): string | undefined;
    get privateEndpointResourceId(): string;
    private _privateLinkId?;
    get privateLinkId(): string;
    set privateLinkId(value: string);
    get privateLinkIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _endpoints;
    get endpoints(): PrivatelinkEndpointServiceEndpointsList;
    putEndpoints(value: PrivatelinkEndpointServiceEndpoints[] | cdktf.IResolvable): void;
    resetEndpoints(): void;
    get endpointsInput(): cdktf.IResolvable | PrivatelinkEndpointServiceEndpoints[] | undefined;
    private _timeouts;
    get timeouts(): PrivatelinkEndpointServiceTimeoutsOutputReference;
    putTimeouts(value: PrivatelinkEndpointServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatelinkEndpointServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
