import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatelinkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#id PrivatelinkEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#project_id PrivatelinkEndpoint#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#provider_name PrivatelinkEndpoint#provider_name}
    */
    readonly providerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#region PrivatelinkEndpoint#region}
    */
    readonly region: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#timeouts PrivatelinkEndpoint#timeouts}
    */
    readonly timeouts?: PrivatelinkEndpointTimeouts;
}
export interface PrivatelinkEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#create PrivatelinkEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint#delete PrivatelinkEndpoint#delete}
    */
    readonly delete?: string;
}
export declare function privatelinkEndpointTimeoutsToTerraform(struct?: PrivatelinkEndpointTimeoutsOutputReference | PrivatelinkEndpointTimeouts | cdktf.IResolvable): any;
export declare class PrivatelinkEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatelinkEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatelinkEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint mongodbatlas_privatelink_endpoint}
*/
export declare class PrivatelinkEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_privatelink_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/privatelink_endpoint mongodbatlas_privatelink_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatelinkEndpointConfig
    */
    constructor(scope: Construct, id: string, config: PrivatelinkEndpointConfig);
    get endpointGroupNames(): string[];
    get endpointServiceName(): string;
    get errorMessage(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get interfaceEndpoints(): string[];
    get privateEndpoints(): string[];
    get privateLinkId(): string;
    get privateLinkServiceName(): string;
    get privateLinkServiceResourceId(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerName?;
    get providerName(): string;
    set providerName(value: string);
    get providerNameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    get regionInput(): string | undefined;
    get regionName(): string;
    get serviceAttachmentNames(): string[];
    get status(): string;
    private _timeouts;
    get timeouts(): PrivatelinkEndpointTimeoutsOutputReference;
    putTimeouts(value: PrivatelinkEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatelinkEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
