import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectApiKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key#description ProjectApiKey#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key#id ProjectApiKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key#project_id ProjectApiKey#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key#role_names ProjectApiKey#role_names}
    */
    readonly roleNames: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key mongodbatlas_project_api_key}
*/
export declare class ProjectApiKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_project_api_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_api_key mongodbatlas_project_api_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectApiKeyConfig
    */
    constructor(scope: Construct, id: string, config: ProjectApiKeyConfig);
    get apiKeyId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get privateKey(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    get publicKey(): string;
    private _roleNames?;
    get roleNames(): string[];
    set roleNames(value: string[]);
    get roleNamesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
