import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectIpAccessListConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#aws_security_group ProjectIpAccessList#aws_security_group}
    */
    readonly awsSecurityGroup?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#cidr_block ProjectIpAccessList#cidr_block}
    */
    readonly cidrBlock?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#comment ProjectIpAccessList#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#id ProjectIpAccessList#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#ip_address ProjectIpAccessList#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#project_id ProjectIpAccessList#project_id}
    */
    readonly projectId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#timeouts ProjectIpAccessList#timeouts}
    */
    readonly timeouts?: ProjectIpAccessListTimeouts;
}
export interface ProjectIpAccessListTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#delete ProjectIpAccessList#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list#read ProjectIpAccessList#read}
    */
    readonly read?: string;
}
export declare function projectIpAccessListTimeoutsToTerraform(struct?: ProjectIpAccessListTimeoutsOutputReference | ProjectIpAccessListTimeouts | cdktf.IResolvable): any;
export declare class ProjectIpAccessListTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectIpAccessListTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectIpAccessListTimeouts | cdktf.IResolvable | undefined);
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list mongodbatlas_project_ip_access_list}
*/
export declare class ProjectIpAccessList extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_project_ip_access_list";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project_ip_access_list mongodbatlas_project_ip_access_list} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIpAccessListConfig
    */
    constructor(scope: Construct, id: string, config: ProjectIpAccessListConfig);
    private _awsSecurityGroup?;
    get awsSecurityGroup(): string;
    set awsSecurityGroup(value: string);
    resetAwsSecurityGroup(): void;
    get awsSecurityGroupInput(): string | undefined;
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    resetCidrBlock(): void;
    get cidrBlockInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ProjectIpAccessListTimeoutsOutputReference;
    putTimeouts(value: ProjectIpAccessListTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ProjectIpAccessListTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
