import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#id Project#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#is_collect_database_specifics_statistics_enabled Project#is_collect_database_specifics_statistics_enabled}
    */
    readonly isCollectDatabaseSpecificsStatisticsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#is_data_explorer_enabled Project#is_data_explorer_enabled}
    */
    readonly isDataExplorerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#is_performance_advisor_enabled Project#is_performance_advisor_enabled}
    */
    readonly isPerformanceAdvisorEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#is_realtime_performance_panel_enabled Project#is_realtime_performance_panel_enabled}
    */
    readonly isRealtimePerformancePanelEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#is_schema_advisor_enabled Project#is_schema_advisor_enabled}
    */
    readonly isSchemaAdvisorEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#name Project#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#org_id Project#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#project_owner_id Project#project_owner_id}
    */
    readonly projectOwnerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#region_usage_restrictions Project#region_usage_restrictions}
    */
    readonly regionUsageRestrictions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#with_default_alerts_settings Project#with_default_alerts_settings}
    */
    readonly withDefaultAlertsSettings?: boolean | cdktf.IResolvable;
    /**
    * api_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#api_keys Project#api_keys}
    */
    readonly apiKeys?: ProjectApiKeys[] | cdktf.IResolvable;
    /**
    * teams block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#teams Project#teams}
    */
    readonly teams?: ProjectTeams[] | cdktf.IResolvable;
}
export interface ProjectApiKeys {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#api_key_id Project#api_key_id}
    */
    readonly apiKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#role_names Project#role_names}
    */
    readonly roleNames: string[];
}
export declare function projectApiKeysToTerraform(struct?: ProjectApiKeys | cdktf.IResolvable): any;
export declare class ProjectApiKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectApiKeys | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectApiKeys | cdktf.IResolvable | undefined);
    private _apiKeyId?;
    get apiKeyId(): string;
    set apiKeyId(value: string);
    get apiKeyIdInput(): string | undefined;
    private _roleNames?;
    get roleNames(): string[];
    set roleNames(value: string[]);
    get roleNamesInput(): string[] | undefined;
}
export declare class ProjectApiKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectApiKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectApiKeysOutputReference;
}
export interface ProjectTeams {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#role_names Project#role_names}
    */
    readonly roleNames: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project#team_id Project#team_id}
    */
    readonly teamId: string;
}
export declare function projectTeamsToTerraform(struct?: ProjectTeams | cdktf.IResolvable): any;
export declare class ProjectTeamsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProjectTeams | cdktf.IResolvable | undefined;
    set internalValue(value: ProjectTeams | cdktf.IResolvable | undefined);
    private _roleNames?;
    get roleNames(): string[];
    set roleNames(value: string[]);
    get roleNamesInput(): string[] | undefined;
    private _teamId?;
    get teamId(): string;
    set teamId(value: string);
    get teamIdInput(): string | undefined;
}
export declare class ProjectTeamsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProjectTeams[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProjectTeamsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project mongodbatlas_project}
*/
export declare class Project extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/project mongodbatlas_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectConfig
    */
    constructor(scope: Construct, id: string, config: ProjectConfig);
    get clusterCount(): number;
    get created(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isCollectDatabaseSpecificsStatisticsEnabled?;
    get isCollectDatabaseSpecificsStatisticsEnabled(): boolean | cdktf.IResolvable;
    set isCollectDatabaseSpecificsStatisticsEnabled(value: boolean | cdktf.IResolvable);
    resetIsCollectDatabaseSpecificsStatisticsEnabled(): void;
    get isCollectDatabaseSpecificsStatisticsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isDataExplorerEnabled?;
    get isDataExplorerEnabled(): boolean | cdktf.IResolvable;
    set isDataExplorerEnabled(value: boolean | cdktf.IResolvable);
    resetIsDataExplorerEnabled(): void;
    get isDataExplorerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isPerformanceAdvisorEnabled?;
    get isPerformanceAdvisorEnabled(): boolean | cdktf.IResolvable;
    set isPerformanceAdvisorEnabled(value: boolean | cdktf.IResolvable);
    resetIsPerformanceAdvisorEnabled(): void;
    get isPerformanceAdvisorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isRealtimePerformancePanelEnabled?;
    get isRealtimePerformancePanelEnabled(): boolean | cdktf.IResolvable;
    set isRealtimePerformancePanelEnabled(value: boolean | cdktf.IResolvable);
    resetIsRealtimePerformancePanelEnabled(): void;
    get isRealtimePerformancePanelEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isSchemaAdvisorEnabled?;
    get isSchemaAdvisorEnabled(): boolean | cdktf.IResolvable;
    set isSchemaAdvisorEnabled(value: boolean | cdktf.IResolvable);
    resetIsSchemaAdvisorEnabled(): void;
    get isSchemaAdvisorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _projectOwnerId?;
    get projectOwnerId(): string;
    set projectOwnerId(value: string);
    resetProjectOwnerId(): void;
    get projectOwnerIdInput(): string | undefined;
    private _regionUsageRestrictions?;
    get regionUsageRestrictions(): string;
    set regionUsageRestrictions(value: string);
    resetRegionUsageRestrictions(): void;
    get regionUsageRestrictionsInput(): string | undefined;
    private _withDefaultAlertsSettings?;
    get withDefaultAlertsSettings(): boolean | cdktf.IResolvable;
    set withDefaultAlertsSettings(value: boolean | cdktf.IResolvable);
    resetWithDefaultAlertsSettings(): void;
    get withDefaultAlertsSettingsInput(): boolean | cdktf.IResolvable | undefined;
    private _apiKeys;
    get apiKeys(): ProjectApiKeysList;
    putApiKeys(value: ProjectApiKeys[] | cdktf.IResolvable): void;
    resetApiKeys(): void;
    get apiKeysInput(): cdktf.IResolvable | ProjectApiKeys[] | undefined;
    private _teams;
    get teams(): ProjectTeamsList;
    putTeams(value: ProjectTeams[] | cdktf.IResolvable): void;
    resetTeams(): void;
    get teamsInput(): cdktf.IResolvable | ProjectTeams[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
