import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MongodbatlasProviderConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#aws_access_key_id MongodbatlasProvider#aws_access_key_id}
    */
    readonly awsAccessKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#aws_secret_access_key MongodbatlasProvider#aws_secret_access_key}
    */
    readonly awsSecretAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#aws_session_token MongodbatlasProvider#aws_session_token}
    */
    readonly awsSessionToken?: string;
    /**
    * MongoDB Atlas Base URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#base_url MongodbatlasProvider#base_url}
    */
    readonly baseUrl?: string;
    /**
    * MongoDB Atlas Base URL default to gov
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#is_mongodbgov_cloud MongodbatlasProvider#is_mongodbgov_cloud}
    */
    readonly isMongodbgovCloud?: boolean | cdktf.IResolvable;
    /**
    * MongoDB Atlas Programmatic Private Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#private_key MongodbatlasProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * MongoDB Atlas Programmatic Public Key
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#public_key MongodbatlasProvider#public_key}
    */
    readonly publicKey?: string;
    /**
    * MongoDB Realm Base URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#realm_base_url MongodbatlasProvider#realm_base_url}
    */
    readonly realmBaseUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#region MongodbatlasProvider#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#secret_name MongodbatlasProvider#secret_name}
    */
    readonly secretName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#sts_endpoint MongodbatlasProvider#sts_endpoint}
    */
    readonly stsEndpoint?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#alias MongodbatlasProvider#alias}
    */
    readonly alias?: string;
    /**
    * assume_role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#assume_role MongodbatlasProvider#assume_role}
    */
    readonly assumeRole?: MongodbatlasProviderAssumeRole;
}
export interface MongodbatlasProviderAssumeRole {
    /**
    * The duration, between 15 minutes and 12 hours, of the role session. Valid time units are ns, us (or µs), ms, s, h, or m.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#duration MongodbatlasProvider#duration}
    */
    readonly duration?: string;
    /**
    * The duration, in seconds, of the role session.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#duration_seconds MongodbatlasProvider#duration_seconds}
    */
    readonly durationSeconds?: number;
    /**
    * A unique identifier that might be required when you assume a role in another account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#external_id MongodbatlasProvider#external_id}
    */
    readonly externalId?: string;
    /**
    * IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#policy MongodbatlasProvider#policy}
    */
    readonly policy?: string;
    /**
    * Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the IAM Role being assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#policy_arns MongodbatlasProvider#policy_arns}
    */
    readonly policyArns?: string[];
    /**
    * Amazon Resource Name (ARN) of an IAM Role to assume prior to making API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#role_arn MongodbatlasProvider#role_arn}
    */
    readonly roleArn?: string;
    /**
    * An identifier for the assumed role session.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#session_name MongodbatlasProvider#session_name}
    */
    readonly sessionName?: string;
    /**
    * Source identity specified by the principal assuming the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#source_identity MongodbatlasProvider#source_identity}
    */
    readonly sourceIdentity?: string;
    /**
    * Assume role session tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#tags MongodbatlasProvider#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Assume role session tag keys to pass to any subsequent sessions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas#transitive_tag_keys MongodbatlasProvider#transitive_tag_keys}
    */
    readonly transitiveTagKeys?: string[];
}
export declare function mongodbatlasProviderAssumeRoleToTerraform(struct?: MongodbatlasProviderAssumeRole): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas mongodbatlas}
*/
export declare class MongodbatlasProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "mongodbatlas";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas mongodbatlas} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MongodbatlasProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: MongodbatlasProviderConfig);
    private _awsAccessKeyId?;
    get awsAccessKeyId(): string | undefined;
    set awsAccessKeyId(value: string | undefined);
    resetAwsAccessKeyId(): void;
    get awsAccessKeyIdInput(): string | undefined;
    private _awsSecretAccessKey?;
    get awsSecretAccessKey(): string | undefined;
    set awsSecretAccessKey(value: string | undefined);
    resetAwsSecretAccessKey(): void;
    get awsSecretAccessKeyInput(): string | undefined;
    private _awsSessionToken?;
    get awsSessionToken(): string | undefined;
    set awsSessionToken(value: string | undefined);
    resetAwsSessionToken(): void;
    get awsSessionTokenInput(): string | undefined;
    private _baseUrl?;
    get baseUrl(): string | undefined;
    set baseUrl(value: string | undefined);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _isMongodbgovCloud?;
    get isMongodbgovCloud(): boolean | cdktf.IResolvable | undefined;
    set isMongodbgovCloud(value: boolean | cdktf.IResolvable | undefined);
    resetIsMongodbgovCloud(): void;
    get isMongodbgovCloudInput(): boolean | cdktf.IResolvable | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _publicKey?;
    get publicKey(): string | undefined;
    set publicKey(value: string | undefined);
    resetPublicKey(): void;
    get publicKeyInput(): string | undefined;
    private _realmBaseUrl?;
    get realmBaseUrl(): string | undefined;
    set realmBaseUrl(value: string | undefined);
    resetRealmBaseUrl(): void;
    get realmBaseUrlInput(): string | undefined;
    private _region?;
    get region(): string | undefined;
    set region(value: string | undefined);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secretName?;
    get secretName(): string | undefined;
    set secretName(value: string | undefined);
    resetSecretName(): void;
    get secretNameInput(): string | undefined;
    private _stsEndpoint?;
    get stsEndpoint(): string | undefined;
    set stsEndpoint(value: string | undefined);
    resetStsEndpoint(): void;
    get stsEndpointInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _assumeRole?;
    get assumeRole(): MongodbatlasProviderAssumeRole | undefined;
    set assumeRole(value: MongodbatlasProviderAssumeRole | undefined);
    resetAssumeRole(): void;
    get assumeRoleInput(): MongodbatlasProviderAssumeRole | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
