import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SearchIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#analyzer SearchIndex#analyzer}
    */
    readonly analyzer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#analyzers SearchIndex#analyzers}
    */
    readonly analyzers?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#cluster_name SearchIndex#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#collection_name SearchIndex#collection_name}
    */
    readonly collectionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#database SearchIndex#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#id SearchIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#mappings_dynamic SearchIndex#mappings_dynamic}
    */
    readonly mappingsDynamic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#mappings_fields SearchIndex#mappings_fields}
    */
    readonly mappingsFields?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#name SearchIndex#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#project_id SearchIndex#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#search_analyzer SearchIndex#search_analyzer}
    */
    readonly searchAnalyzer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#status SearchIndex#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#wait_for_index_build_completion SearchIndex#wait_for_index_build_completion}
    */
    readonly waitForIndexBuildCompletion?: boolean | cdktf.IResolvable;
    /**
    * synonyms block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#synonyms SearchIndex#synonyms}
    */
    readonly synonyms?: SearchIndexSynonyms[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#timeouts SearchIndex#timeouts}
    */
    readonly timeouts?: SearchIndexTimeouts;
}
export interface SearchIndexSynonyms {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#analyzer SearchIndex#analyzer}
    */
    readonly analyzer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#name SearchIndex#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#source_collection SearchIndex#source_collection}
    */
    readonly sourceCollection: string;
}
export declare function searchIndexSynonymsToTerraform(struct?: SearchIndexSynonyms | cdktf.IResolvable): any;
export declare class SearchIndexSynonymsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SearchIndexSynonyms | cdktf.IResolvable | undefined;
    set internalValue(value: SearchIndexSynonyms | cdktf.IResolvable | undefined);
    private _analyzer?;
    get analyzer(): string;
    set analyzer(value: string);
    get analyzerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceCollection?;
    get sourceCollection(): string;
    set sourceCollection(value: string);
    get sourceCollectionInput(): string | undefined;
}
export declare class SearchIndexSynonymsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SearchIndexSynonyms[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SearchIndexSynonymsOutputReference;
}
export interface SearchIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#create SearchIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#delete SearchIndex#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index#update SearchIndex#update}
    */
    readonly update?: string;
}
export declare function searchIndexTimeoutsToTerraform(struct?: SearchIndexTimeoutsOutputReference | SearchIndexTimeouts | cdktf.IResolvable): any;
export declare class SearchIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SearchIndexTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SearchIndexTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index mongodbatlas_search_index}
*/
export declare class SearchIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_search_index";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/search_index mongodbatlas_search_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SearchIndexConfig
    */
    constructor(scope: Construct, id: string, config: SearchIndexConfig);
    private _analyzer?;
    get analyzer(): string;
    set analyzer(value: string);
    get analyzerInput(): string | undefined;
    private _analyzers?;
    get analyzers(): string;
    set analyzers(value: string);
    resetAnalyzers(): void;
    get analyzersInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _collectionName?;
    get collectionName(): string;
    set collectionName(value: string);
    get collectionNameInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get indexId(): string;
    private _mappingsDynamic?;
    get mappingsDynamic(): boolean | cdktf.IResolvable;
    set mappingsDynamic(value: boolean | cdktf.IResolvable);
    resetMappingsDynamic(): void;
    get mappingsDynamicInput(): boolean | cdktf.IResolvable | undefined;
    private _mappingsFields?;
    get mappingsFields(): string;
    set mappingsFields(value: string);
    resetMappingsFields(): void;
    get mappingsFieldsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _searchAnalyzer?;
    get searchAnalyzer(): string;
    set searchAnalyzer(value: string);
    resetSearchAnalyzer(): void;
    get searchAnalyzerInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _waitForIndexBuildCompletion?;
    get waitForIndexBuildCompletion(): boolean | cdktf.IResolvable;
    set waitForIndexBuildCompletion(value: boolean | cdktf.IResolvable);
    resetWaitForIndexBuildCompletion(): void;
    get waitForIndexBuildCompletionInput(): boolean | cdktf.IResolvable | undefined;
    private _synonyms;
    get synonyms(): SearchIndexSynonymsList;
    putSynonyms(value: SearchIndexSynonyms[] | cdktf.IResolvable): void;
    resetSynonyms(): void;
    get synonymsInput(): cdktf.IResolvable | SearchIndexSynonyms[] | undefined;
    private _timeouts;
    get timeouts(): SearchIndexTimeoutsOutputReference;
    putTimeouts(value: SearchIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SearchIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
