import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerlessInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#continuous_backup_enabled ServerlessInstance#continuous_backup_enabled}
    */
    readonly continuousBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#id ServerlessInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#name ServerlessInstance#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#project_id ServerlessInstance#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#provider_settings_backing_provider_name ServerlessInstance#provider_settings_backing_provider_name}
    */
    readonly providerSettingsBackingProviderName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#provider_settings_provider_name ServerlessInstance#provider_settings_provider_name}
    */
    readonly providerSettingsProviderName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#provider_settings_region_name ServerlessInstance#provider_settings_region_name}
    */
    readonly providerSettingsRegionName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#state_name ServerlessInstance#state_name}
    */
    readonly stateName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#termination_protection_enabled ServerlessInstance#termination_protection_enabled}
    */
    readonly terminationProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * links block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance#links ServerlessInstance#links}
    */
    readonly links?: ServerlessInstanceLinks[] | cdktf.IResolvable;
}
export interface ServerlessInstanceLinks {
}
export declare function serverlessInstanceLinksToTerraform(struct?: ServerlessInstanceLinks | cdktf.IResolvable): any;
export declare class ServerlessInstanceLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServerlessInstanceLinks | cdktf.IResolvable | undefined;
    set internalValue(value: ServerlessInstanceLinks | cdktf.IResolvable | undefined);
    get href(): string;
    get rel(): string;
}
export declare class ServerlessInstanceLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServerlessInstanceLinks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServerlessInstanceLinksOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance mongodbatlas_serverless_instance}
*/
export declare class ServerlessInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_serverless_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/serverless_instance mongodbatlas_serverless_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerlessInstanceConfig
    */
    constructor(scope: Construct, id: string, config: ServerlessInstanceConfig);
    get connectionStringsPrivateEndpointSrv(): string[];
    get connectionStringsStandardSrv(): string;
    private _continuousBackupEnabled?;
    get continuousBackupEnabled(): boolean | cdktf.IResolvable;
    set continuousBackupEnabled(value: boolean | cdktf.IResolvable);
    resetContinuousBackupEnabled(): void;
    get continuousBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get createDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get mongoDbVersion(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _providerSettingsBackingProviderName?;
    get providerSettingsBackingProviderName(): string;
    set providerSettingsBackingProviderName(value: string);
    get providerSettingsBackingProviderNameInput(): string | undefined;
    private _providerSettingsProviderName?;
    get providerSettingsProviderName(): string;
    set providerSettingsProviderName(value: string);
    get providerSettingsProviderNameInput(): string | undefined;
    private _providerSettingsRegionName?;
    get providerSettingsRegionName(): string;
    set providerSettingsRegionName(value: string);
    get providerSettingsRegionNameInput(): string | undefined;
    private _stateName?;
    get stateName(): string;
    set stateName(value: string);
    resetStateName(): void;
    get stateNameInput(): string | undefined;
    private _terminationProtectionEnabled?;
    get terminationProtectionEnabled(): boolean | cdktf.IResolvable;
    set terminationProtectionEnabled(value: boolean | cdktf.IResolvable);
    resetTerminationProtectionEnabled(): void;
    get terminationProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _links;
    get links(): ServerlessInstanceLinksList;
    putLinks(value: ServerlessInstanceLinks[] | cdktf.IResolvable): void;
    resetLinks(): void;
    get linksInput(): cdktf.IResolvable | ServerlessInstanceLinks[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
