import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TeamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team#id Team#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team#name Team#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team#org_id Team#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team#usernames Team#usernames}
    */
    readonly usernames: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team mongodbatlas_team}
*/
export declare class Team extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_team";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/team mongodbatlas_team} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TeamConfig
    */
    constructor(scope: Construct, id: string, config: TeamConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    get teamId(): string;
    private _usernames?;
    get usernames(): string[];
    set usernames(value: string[]);
    get usernamesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
