import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface X509AuthenticationDatabaseUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user#customer_x509_cas X509AuthenticationDatabaseUser#customer_x509_cas}
    */
    readonly customerX509Cas?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user#id X509AuthenticationDatabaseUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user#months_until_expiration X509AuthenticationDatabaseUser#months_until_expiration}
    */
    readonly monthsUntilExpiration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user#project_id X509AuthenticationDatabaseUser#project_id}
    */
    readonly projectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user#username X509AuthenticationDatabaseUser#username}
    */
    readonly username?: string;
}
export interface X509AuthenticationDatabaseUserCertificates {
}
export declare function x509AuthenticationDatabaseUserCertificatesToTerraform(struct?: X509AuthenticationDatabaseUserCertificates): any;
export declare class X509AuthenticationDatabaseUserCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): X509AuthenticationDatabaseUserCertificates | undefined;
    set internalValue(value: X509AuthenticationDatabaseUserCertificates | undefined);
    get createdAt(): string;
    get groupId(): string;
    get id(): number;
    get notAfter(): string;
    get subject(): string;
}
export declare class X509AuthenticationDatabaseUserCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): X509AuthenticationDatabaseUserCertificatesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user mongodbatlas_x509_authentication_database_user}
*/
export declare class X509AuthenticationDatabaseUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "mongodbatlas_x509_authentication_database_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/mongodbatlas/r/x509_authentication_database_user mongodbatlas_x509_authentication_database_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options X509AuthenticationDatabaseUserConfig
    */
    constructor(scope: Construct, id: string, config: X509AuthenticationDatabaseUserConfig);
    private _certificates;
    get certificates(): X509AuthenticationDatabaseUserCertificatesList;
    get currentCertificate(): string;
    private _customerX509Cas?;
    get customerX509Cas(): string;
    set customerX509Cas(value: string);
    resetCustomerX509Cas(): void;
    get customerX509CasInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monthsUntilExpiration?;
    get monthsUntilExpiration(): number;
    set monthsUntilExpiration(value: number);
    resetMonthsUntilExpiration(): void;
    get monthsUntilExpirationInput(): number | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
