# mypy-boto3-devops-guru

[![PyPI - mypy-boto3-devops-guru](https://img.shields.io/pypi/v/mypy-boto3-devops-guru.svg?color=blue)](https://pypi.org/project/mypy-boto3-devops-guru)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-devops-guru.svg?color=blue)](https://pypi.org/project/mypy-boto3-devops-guru)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-devops-guru?color=blue)](https://pypistats.org/packages/mypy-boto3-devops-guru)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.DevopsGuru 1.17.62](https://boto3.amazonaws.com/v1/documentation/api/1.17.62/reference/services/devops-guru.html#DevopsGuru) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.8.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[auto-generated docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_devops_guru/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-devops-guru](#mypy-boto3-devops-guru)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `DevopsGuru` service.

```bash
python -m pip install boto3-stubs[devops-guru]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[devops-guru]` in your environment: `python -m pip install 'boto3-stubs[devops-guru]'`

Both type checking and auto-complete should work for `DevopsGuru` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[devops-guru]` in your environment: `python -m pip install 'boto3-stubs[devops-guru]'`

Both type checking and auto-complete should work for `DevopsGuru` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[devops-guru]` in your environment: `python -m pip install 'boto3-stubs[devops-guru]'`
- Run `mypy` as usual

Type checking should work for `DevopsGuru` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[devops-guru]` in your environment: `python -m pip install 'boto3-stubs[devops-guru]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `DevopsGuru` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`DevopsGuruClient` provides annotations for `boto3.client("devops-guru")`.

```python
import boto3

from mypy_boto3_devops_guru import DevopsGuruClient

client: DevopsGuruClient = boto3.client("devops-guru")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: DevopsGuruClient = session.client("devops-guru")
```

### Paginators annotations

`mypy_boto3_devops_guru.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_devops_guru import DevopsGuruClient
from mypy_boto3_devops_guru.paginator import (
    DescribeResourceCollectionHealthPaginator,
    GetResourceCollectionPaginator,
    ListAnomaliesForInsightPaginator,
    ListEventsPaginator,
    ListInsightsPaginator,
    ListNotificationChannelsPaginator,
    ListRecommendationsPaginator,
    SearchInsightsPaginator,
)

client: DevopsGuruClient = boto3.client("devops-guru")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_resource_collection_health_paginator: DescribeResourceCollectionHealthPaginator = client.get_paginator("describe_resource_collection_health")
get_resource_collection_paginator: GetResourceCollectionPaginator = client.get_paginator("get_resource_collection")
list_anomalies_for_insight_paginator: ListAnomaliesForInsightPaginator = client.get_paginator("list_anomalies_for_insight")
list_events_paginator: ListEventsPaginator = client.get_paginator("list_events")
list_insights_paginator: ListInsightsPaginator = client.get_paginator("list_insights")
list_notification_channels_paginator: ListNotificationChannelsPaginator = client.get_paginator("list_notification_channels")
list_recommendations_paginator: ListRecommendationsPaginator = client.get_paginator("list_recommendations")
search_insights_paginator: SearchInsightsPaginator = client.get_paginator("search_insights")
```







### Literals

`mypy_boto3_devops_guru.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_devops_guru.literals import (
    AnomalySeverity,
    AnomalyStatus,
    CloudWatchMetricsStat,
    DescribeResourceCollectionHealthPaginatorName,
    EventClass,
    EventDataSource,
    GetResourceCollectionPaginatorName,
    InsightFeedbackOption,
    InsightSeverity,
    InsightStatus,
    InsightType,
    ListAnomaliesForInsightPaginatorName,
    ListEventsPaginatorName,
    ListInsightsPaginatorName,
    ListNotificationChannelsPaginatorName,
    ListRecommendationsPaginatorName,
    OptInStatus,
    ResourceCollectionType,
    SearchInsightsPaginatorName,
    UpdateResourceCollectionAction,
)

def check_value(value: AnomalySeverity) -> bool:
    ...
```



### Typed dictionaries

`mypy_boto3_devops_guru.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_devops_guru.type_defs import (
    AddNotificationChannelResponseTypeDef,
    AnomalySourceDetailsTypeDef,
    AnomalyTimeRangeTypeDef,
    CloudFormationCollectionFilterTypeDef,
    CloudFormationCollectionTypeDef,
    CloudFormationHealthTypeDef,
    CloudWatchMetricsDetailTypeDef,
    CloudWatchMetricsDimensionTypeDef,
    DescribeAccountHealthResponseTypeDef,
    DescribeAccountOverviewResponseTypeDef,
    DescribeAnomalyResponseTypeDef,
    DescribeFeedbackResponseTypeDef,
    DescribeInsightResponseTypeDef,
    DescribeResourceCollectionHealthResponseTypeDef,
    DescribeServiceIntegrationResponseTypeDef,
    EndTimeRangeTypeDef,
    EventResourceTypeDef,
    EventTimeRangeTypeDef,
    EventTypeDef,
    GetResourceCollectionResponseTypeDef,
    InsightFeedbackTypeDef,
    InsightHealthTypeDef,
    InsightTimeRangeTypeDef,
    ListAnomaliesForInsightResponseTypeDef,
    ListEventsFiltersTypeDef,
    ListEventsResponseTypeDef,
    ListInsightsAnyStatusFilterTypeDef,
    ListInsightsClosedStatusFilterTypeDef,
    ListInsightsOngoingStatusFilterTypeDef,
    ListInsightsResponseTypeDef,
    ListInsightsStatusFilterTypeDef,
    ListNotificationChannelsResponseTypeDef,
    ListRecommendationsResponseTypeDef,
    NotificationChannelConfigTypeDef,
    NotificationChannelTypeDef,
    OpsCenterIntegrationConfigTypeDef,
    OpsCenterIntegrationTypeDef,
    PaginatorConfigTypeDef,
    PredictionTimeRangeTypeDef,
    ProactiveAnomalySummaryTypeDef,
    ProactiveAnomalyTypeDef,
    ProactiveInsightSummaryTypeDef,
    ProactiveInsightTypeDef,
    ReactiveAnomalySummaryTypeDef,
    ReactiveAnomalyTypeDef,
    ReactiveInsightSummaryTypeDef,
    ReactiveInsightTypeDef,
    RecommendationRelatedAnomalyResourceTypeDef,
    RecommendationRelatedAnomalySourceDetailTypeDef,
    RecommendationRelatedAnomalyTypeDef,
    RecommendationRelatedCloudWatchMetricsSourceDetailTypeDef,
    RecommendationRelatedEventResourceTypeDef,
    RecommendationRelatedEventTypeDef,
    RecommendationTypeDef,
    ResourceCollectionFilterTypeDef,
    ResourceCollectionTypeDef,
    SearchInsightsFiltersTypeDef,
    SearchInsightsResponseTypeDef,
    ServiceIntegrationConfigTypeDef,
    SnsChannelConfigTypeDef,
    StartTimeRangeTypeDef,
    UpdateCloudFormationCollectionFilterTypeDef,
    UpdateResourceCollectionFilterTypeDef,
    UpdateServiceIntegrationConfigTypeDef,
)

def get_structure() -> AddNotificationChannelResponseTypeDef:
    return {
      ...
    }
```
