#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Word list originally created by dabura667 and released under The MIT License (MIT)
#
# The MIT License (MIT)
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#
# Code surrounding the word list is Copyright (c) 2014-2018, The Monero Project
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are
# permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, this list of
#    conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice, this list
#    of conditions and the following disclaimer in the documentation and/or other
#    materials provided with the distribution.
#
# 3. Neither the name of the copyright holder nor the names of its contributors may be
#    used to endorse or promote products derived from this software without specific
#    prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
# THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
# THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# list of words from:
#     https://github.com/monero-project/monero/blob/master/src/mnemonics/japanese.h
#     Most recent commit: 8ea3c4d54429976e9001b8cc4868b721e6747e3c


from .wordlist import Wordlist


class Japanese(Wordlist):
    language_name = u"日本語"
    english_language_name = "Japanese"
    unique_prefix_length = 4
    word_list = [
        u"あいこくしん",
        u"あいさつ",
        u"あいだ",
        u"あおぞら",
        u"あかちゃん",
        u"あきる",
        u"あけがた",
        u"あける",
        u"あこがれる",
        u"あさい",
        u"あさひ",
        u"あしあと",
        u"あじわう",
        u"あずかる",
        u"あずき",
        u"あそぶ",
        u"あたえる",
        u"あたためる",
        u"あたりまえ",
        u"あたる",
        u"あつい",
        u"あつかう",
        u"あっしゅく",
        u"あつまり",
        u"あつめる",
        u"あてな",
        u"あてはまる",
        u"あひる",
        u"あぶら",
        u"あぶる",
        u"あふれる",
        u"あまい",
        u"あまど",
        u"あまやかす",
        u"あまり",
        u"あみもの",
        u"あめりか",
        u"あやまる",
        u"あゆむ",
        u"あらいぐま",
        u"あらし",
        u"あらすじ",
        u"あらためる",
        u"あらゆる",
        u"あらわす",
        u"ありがとう",
        u"あわせる",
        u"あわてる",
        u"あんい",
        u"あんがい",
        u"あんこ",
        u"あんぜん",
        u"あんてい",
        u"あんない",
        u"あんまり",
        u"いいだす",
        u"いおん",
        u"いがい",
        u"いがく",
        u"いきおい",
        u"いきなり",
        u"いきもの",
        u"いきる",
        u"いくじ",
        u"いくぶん",
        u"いけばな",
        u"いけん",
        u"いこう",
        u"いこく",
        u"いこつ",
        u"いさましい",
        u"いさん",
        u"いしき",
        u"いじゅう",
        u"いじょう",
        u"いじわる",
        u"いずみ",
        u"いずれ",
        u"いせい",
        u"いせえび",
        u"いせかい",
        u"いせき",
        u"いぜん",
        u"いそうろう",
        u"いそがしい",
        u"いだい",
        u"いだく",
        u"いたずら",
        u"いたみ",
        u"いたりあ",
        u"いちおう",
        u"いちじ",
        u"いちど",
        u"いちば",
        u"いちぶ",
        u"いちりゅう",
        u"いつか",
        u"いっしゅん",
        u"いっせい",
        u"いっそう",
        u"いったん",
        u"いっち",
        u"いってい",
        u"いっぽう",
        u"いてざ",
        u"いてん",
        u"いどう",
        u"いとこ",
        u"いない",
        u"いなか",
        u"いねむり",
        u"いのち",
        u"いのる",
        u"いはつ",
        u"いばる",
        u"いはん",
        u"いびき",
        u"いひん",
        u"いふく",
        u"いへん",
        u"いほう",
        u"いみん",
        u"いもうと",
        u"いもたれ",
        u"いもり",
        u"いやがる",
        u"いやす",
        u"いよかん",
        u"いよく",
        u"いらい",
        u"いらすと",
        u"いりぐち",
        u"いりょう",
        u"いれい",
        u"いれもの",
        u"いれる",
        u"いろえんぴつ",
        u"いわい",
        u"いわう",
        u"いわかん",
        u"いわば",
        u"いわゆる",
        u"いんげんまめ",
        u"いんさつ",
        u"いんしょう",
        u"いんよう",
        u"うえき",
        u"うえる",
        u"うおざ",
        u"うがい",
        u"うかぶ",
        u"うかべる",
        u"うきわ",
        u"うくらいな",
        u"うくれれ",
        u"うけたまわる",
        u"うけつけ",
        u"うけとる",
        u"うけもつ",
        u"うける",
        u"うごかす",
        u"うごく",
        u"うこん",
        u"うさぎ",
        u"うしなう",
        u"うしろがみ",
        u"うすい",
        u"うすぎ",
        u"うすぐらい",
        u"うすめる",
        u"うせつ",
        u"うちあわせ",
        u"うちがわ",
        u"うちき",
        u"うちゅう",
        u"うっかり",
        u"うつくしい",
        u"うったえる",
        u"うつる",
        u"うどん",
        u"うなぎ",
        u"うなじ",
        u"うなずく",
        u"うなる",
        u"うねる",
        u"うのう",
        u"うぶげ",
        u"うぶごえ",
        u"うまれる",
        u"うめる",
        u"うもう",
        u"うやまう",
        u"うよく",
        u"うらがえす",
        u"うらぐち",
        u"うらない",
        u"うりあげ",
        u"うりきれ",
        u"うるさい",
        u"うれしい",
        u"うれゆき",
        u"うれる",
        u"うろこ",
        u"うわき",
        u"うわさ",
        u"うんこう",
        u"うんちん",
        u"うんてん",
        u"うんどう",
        u"えいえん",
        u"えいが",
        u"えいきょう",
        u"えいご",
        u"えいせい",
        u"えいぶん",
        u"えいよう",
        u"えいわ",
        u"えおり",
        u"えがお",
        u"えがく",
        u"えきたい",
        u"えくせる",
        u"えしゃく",
        u"えすて",
        u"えつらん",
        u"えのぐ",
        u"えほうまき",
        u"えほん",
        u"えまき",
        u"えもじ",
        u"えもの",
        u"えらい",
        u"えらぶ",
        u"えりあ",
        u"えんえん",
        u"えんかい",
        u"えんぎ",
        u"えんげき",
        u"えんしゅう",
        u"えんぜつ",
        u"えんそく",
        u"えんちょう",
        u"えんとつ",
        u"おいかける",
        u"おいこす",
        u"おいしい",
        u"おいつく",
        u"おうえん",
        u"おうさま",
        u"おうじ",
        u"おうせつ",
        u"おうたい",
        u"おうふく",
        u"おうべい",
        u"おうよう",
        u"おえる",
        u"おおい",
        u"おおう",
        u"おおどおり",
        u"おおや",
        u"おおよそ",
        u"おかえり",
        u"おかず",
        u"おがむ",
        u"おかわり",
        u"おぎなう",
        u"おきる",
        u"おくさま",
        u"おくじょう",
        u"おくりがな",
        u"おくる",
        u"おくれる",
        u"おこす",
        u"おこなう",
        u"おこる",
        u"おさえる",
        u"おさない",
        u"おさめる",
        u"おしいれ",
        u"おしえる",
        u"おじぎ",
        u"おじさん",
        u"おしゃれ",
        u"おそらく",
        u"おそわる",
        u"おたがい",
        u"おたく",
        u"おだやか",
        u"おちつく",
        u"おっと",
        u"おつり",
        u"おでかけ",
        u"おとしもの",
        u"おとなしい",
        u"おどり",
        u"おどろかす",
        u"おばさん",
        u"おまいり",
        u"おめでとう",
        u"おもいで",
        u"おもう",
        u"おもたい",
        u"おもちゃ",
        u"おやつ",
        u"おやゆび",
        u"およぼす",
        u"おらんだ",
        u"おろす",
        u"おんがく",
        u"おんけい",
        u"おんしゃ",
        u"おんせん",
        u"おんだん",
        u"おんちゅう",
        u"おんどけい",
        u"かあつ",
        u"かいが",
        u"がいき",
        u"がいけん",
        u"がいこう",
        u"かいさつ",
        u"かいしゃ",
        u"かいすいよく",
        u"かいぜん",
        u"かいぞうど",
        u"かいつう",
        u"かいてん",
        u"かいとう",
        u"かいふく",
        u"がいへき",
        u"かいほう",
        u"かいよう",
        u"がいらい",
        u"かいわ",
        u"かえる",
        u"かおり",
        u"かかえる",
        u"かがく",
        u"かがし",
        u"かがみ",
        u"かくご",
        u"かくとく",
        u"かざる",
        u"がぞう",
        u"かたい",
        u"かたち",
        u"がちょう",
        u"がっきゅう",
        u"がっこう",
        u"がっさん",
        u"がっしょう",
        u"かなざわし",
        u"かのう",
        u"がはく",
        u"かぶか",
        u"かほう",
        u"かほご",
        u"かまう",
        u"かまぼこ",
        u"かめれおん",
        u"かゆい",
        u"かようび",
        u"からい",
        u"かるい",
        u"かろう",
        u"かわく",
        u"かわら",
        u"がんか",
        u"かんけい",
        u"かんこう",
        u"かんしゃ",
        u"かんそう",
        u"かんたん",
        u"かんち",
        u"がんばる",
        u"きあい",
        u"きあつ",
        u"きいろ",
        u"ぎいん",
        u"きうい",
        u"きうん",
        u"きえる",
        u"きおう",
        u"きおく",
        u"きおち",
        u"きおん",
        u"きかい",
        u"きかく",
        u"きかんしゃ",
        u"ききて",
        u"きくばり",
        u"きくらげ",
        u"きけんせい",
        u"きこう",
        u"きこえる",
        u"きこく",
        u"きさい",
        u"きさく",
        u"きさま",
        u"きさらぎ",
        u"ぎじかがく",
        u"ぎしき",
        u"ぎじたいけん",
        u"ぎじにってい",
        u"ぎじゅつしゃ",
        u"きすう",
        u"きせい",
        u"きせき",
        u"きせつ",
        u"きそう",
        u"きぞく",
        u"きぞん",
        u"きたえる",
        u"きちょう",
        u"きつえん",
        u"ぎっちり",
        u"きつつき",
        u"きつね",
        u"きてい",
        u"きどう",
        u"きどく",
        u"きない",
        u"きなが",
        u"きなこ",
        u"きぬごし",
        u"きねん",
        u"きのう",
        u"きのした",
        u"きはく",
        u"きびしい",
        u"きひん",
        u"きふく",
        u"きぶん",
        u"きぼう",
        u"きほん",
        u"きまる",
        u"きみつ",
        u"きむずかしい",
        u"きめる",
        u"きもだめし",
        u"きもち",
        u"きもの",
        u"きゃく",
        u"きやく",
        u"ぎゅうにく",
        u"きよう",
        u"きょうりゅう",
        u"きらい",
        u"きらく",
        u"きりん",
        u"きれい",
        u"きれつ",
        u"きろく",
        u"ぎろん",
        u"きわめる",
        u"ぎんいろ",
        u"きんかくじ",
        u"きんじょ",
        u"きんようび",
        u"ぐあい",
        u"くいず",
        u"くうかん",
        u"くうき",
        u"くうぐん",
        u"くうこう",
        u"ぐうせい",
        u"くうそう",
        u"ぐうたら",
        u"くうふく",
        u"くうぼ",
        u"くかん",
        u"くきょう",
        u"くげん",
        u"ぐこう",
        u"くさい",
        u"くさき",
        u"くさばな",
        u"くさる",
        u"くしゃみ",
        u"くしょう",
        u"くすのき",
        u"くすりゆび",
        u"くせげ",
        u"くせん",
        u"ぐたいてき",
        u"くださる",
        u"くたびれる",
        u"くちこみ",
        u"くちさき",
        u"くつした",
        u"ぐっすり",
        u"くつろぐ",
        u"くとうてん",
        u"くどく",
        u"くなん",
        u"くねくね",
        u"くのう",
        u"くふう",
        u"くみあわせ",
        u"くみたてる",
        u"くめる",
        u"くやくしょ",
        u"くらす",
        u"くらべる",
        u"くるま",
        u"くれる",
        u"くろう",
        u"くわしい",
        u"ぐんかん",
        u"ぐんしょく",
        u"ぐんたい",
        u"ぐんて",
        u"けあな",
        u"けいかく",
        u"けいけん",
        u"けいこ",
        u"けいさつ",
        u"げいじゅつ",
        u"けいたい",
        u"げいのうじん",
        u"けいれき",
        u"けいろ",
        u"けおとす",
        u"けおりもの",
        u"げきか",
        u"げきげん",
        u"げきだん",
        u"げきちん",
        u"げきとつ",
        u"げきは",
        u"げきやく",
        u"げこう",
        u"げこくじょう",
        u"げざい",
        u"けさき",
        u"げざん",
        u"けしき",
        u"けしごむ",
        u"けしょう",
        u"げすと",
        u"けたば",
        u"けちゃっぷ",
        u"けちらす",
        u"けつあつ",
        u"けつい",
        u"けつえき",
        u"けっこん",
        u"けつじょ",
        u"けっせき",
        u"けってい",
        u"けつまつ",
        u"げつようび",
        u"げつれい",
        u"けつろん",
        u"げどく",
        u"けとばす",
        u"けとる",
        u"けなげ",
        u"けなす",
        u"けなみ",
        u"けぬき",
        u"げねつ",
        u"けねん",
        u"けはい",
        u"げひん",
        u"けぶかい",
        u"げぼく",
        u"けまり",
        u"けみかる",
        u"けむし",
        u"けむり",
        u"けもの",
        u"けらい",
        u"けろけろ",
        u"けわしい",
        u"けんい",
        u"けんえつ",
        u"けんお",
        u"けんか",
        u"げんき",
        u"けんげん",
        u"けんこう",
        u"けんさく",
        u"けんしゅう",
        u"けんすう",
        u"げんそう",
        u"けんちく",
        u"けんてい",
        u"けんとう",
        u"けんない",
        u"けんにん",
        u"げんぶつ",
        u"けんま",
        u"けんみん",
        u"けんめい",
        u"けんらん",
        u"けんり",
        u"こあくま",
        u"こいぬ",
        u"こいびと",
        u"ごうい",
        u"こうえん",
        u"こうおん",
        u"こうかん",
        u"ごうきゅう",
        u"ごうけい",
        u"こうこう",
        u"こうさい",
        u"こうじ",
        u"こうすい",
        u"ごうせい",
        u"こうそく",
        u"こうたい",
        u"こうちゃ",
        u"こうつう",
        u"こうてい",
        u"こうどう",
        u"こうない",
        u"こうはい",
        u"ごうほう",
        u"ごうまん",
        u"こうもく",
        u"こうりつ",
        u"こえる",
        u"こおり",
        u"ごかい",
        u"ごがつ",
        u"ごかん",
        u"こくご",
        u"こくさい",
        u"こくとう",
        u"こくない",
        u"こくはく",
        u"こぐま",
        u"こけい",
        u"こける",
        u"ここのか",
        u"こころ",
        u"こさめ",
        u"こしつ",
        u"こすう",
        u"こせい",
        u"こせき",
        u"こぜん",
        u"こそだて",
        u"こたい",
        u"こたえる",
        u"こたつ",
        u"こちょう",
        u"こっか",
        u"こつこつ",
        u"こつばん",
        u"こつぶ",
        u"こてい",
        u"こてん",
        u"ことがら",
        u"ことし",
        u"ことば",
        u"ことり",
        u"こなごな",
        u"こねこね",
        u"このまま",
        u"このみ",
        u"このよ",
        u"ごはん",
        u"こひつじ",
        u"こふう",
        u"こふん",
        u"こぼれる",
        u"ごまあぶら",
        u"こまかい",
        u"ごますり",
        u"こまつな",
        u"こまる",
        u"こむぎこ",
        u"こもじ",
        u"こもち",
        u"こもの",
        u"こもん",
        u"こやく",
        u"こやま",
        u"こゆう",
        u"こゆび",
        u"こよい",
        u"こよう",
        u"こりる",
        u"これくしょん",
        u"ころっけ",
        u"こわもて",
        u"こわれる",
        u"こんいん",
        u"こんかい",
        u"こんき",
        u"こんしゅう",
        u"こんすい",
        u"こんだて",
        u"こんとん",
        u"こんなん",
        u"こんびに",
        u"こんぽん",
        u"こんまけ",
        u"こんや",
        u"こんれい",
        u"こんわく",
        u"ざいえき",
        u"さいかい",
        u"さいきん",
        u"ざいげん",
        u"ざいこ",
        u"さいしょ",
        u"さいせい",
        u"ざいたく",
        u"ざいちゅう",
        u"さいてき",
        u"ざいりょう",
        u"さうな",
        u"さかいし",
        u"さがす",
        u"さかな",
        u"さかみち",
        u"さがる",
        u"さぎょう",
        u"さくし",
        u"さくひん",
        u"さくら",
        u"さこく",
        u"さこつ",
        u"さずかる",
        u"ざせき",
        u"さたん",
        u"さつえい",
        u"ざつおん",
        u"ざっか",
        u"ざつがく",
        u"さっきょく",
        u"ざっし",
        u"さつじん",
        u"ざっそう",
        u"さつたば",
        u"さつまいも",
        u"さてい",
        u"さといも",
        u"さとう",
        u"さとおや",
        u"さとし",
        u"さとる",
        u"さのう",
        u"さばく",
        u"さびしい",
        u"さべつ",
        u"さほう",
        u"さほど",
        u"さます",
        u"さみしい",
        u"さみだれ",
        u"さむけ",
        u"さめる",
        u"さやえんどう",
        u"さゆう",
        u"さよう",
        u"さよく",
        u"さらだ",
        u"ざるそば",
        u"さわやか",
        u"さわる",
        u"さんいん",
        u"さんか",
        u"さんきゃく",
        u"さんこう",
        u"さんさい",
        u"ざんしょ",
        u"さんすう",
        u"さんせい",
        u"さんそ",
        u"さんち",
        u"さんま",
        u"さんみ",
        u"さんらん",
        u"しあい",
        u"しあげ",
        u"しあさって",
        u"しあわせ",
        u"しいく",
        u"しいん",
        u"しうち",
        u"しえい",
        u"しおけ",
        u"しかい",
        u"しかく",
        u"じかん",
        u"しごと",
        u"しすう",
        u"じだい",
        u"したうけ",
        u"したぎ",
        u"したて",
        u"したみ",
        u"しちょう",
        u"しちりん",
        u"しっかり",
        u"しつじ",
        u"しつもん",
        u"してい",
        u"してき",
        u"してつ",
        u"じてん",
        u"じどう",
        u"しなぎれ",
        u"しなもの",
        u"しなん",
        u"しねま",
        u"しねん",
        u"しのぐ",
        u"しのぶ",
        u"しはい",
        u"しばかり",
        u"しはつ",
        u"しはらい",
        u"しはん",
        u"しひょう",
        u"しふく",
        u"じぶん",
        u"しへい",
        u"しほう",
        u"しほん",
        u"しまう",
        u"しまる",
        u"しみん",
        u"しむける",
        u"じむしょ",
        u"しめい",
        u"しめる",
        u"しもん",
        u"しゃいん",
        u"しゃうん",
        u"しゃおん",
        u"じゃがいも",
        u"しやくしょ",
        u"しゃくほう",
        u"しゃけん",
        u"しゃこ",
        u"しゃざい",
        u"しゃしん",
        u"しゃせん",
        u"しゃそう",
        u"しゃたい",
        u"しゃちょう",
        u"しゃっきん",
        u"じゃま",
        u"しゃりん",
        u"しゃれい",
        u"じゆう",
        u"じゅうしょ",
        u"しゅくはく",
        u"じゅしん",
        u"しゅっせき",
        u"しゅみ",
        u"しゅらば",
        u"じゅんばん",
        u"しょうかい",
        u"しょくたく",
        u"しょっけん",
        u"しょどう",
        u"しょもつ",
        u"しらせる",
        u"しらべる",
        u"しんか",
        u"しんこう",
        u"じんじゃ",
        u"しんせいじ",
        u"しんちく",
        u"しんりん",
        u"すあげ",
        u"すあし",
        u"すあな",
        u"ずあん",
        u"すいえい",
        u"すいか",
        u"すいとう",
        u"ずいぶん",
        u"すいようび",
        u"すうがく",
        u"すうじつ",
        u"すうせん",
        u"すおどり",
        u"すきま",
        u"すくう",
        u"すくない",
        u"すける",
        u"すごい",
        u"すこし",
        u"ずさん",
        u"すずしい",
        u"すすむ",
        u"すすめる",
        u"すっかり",
        u"ずっしり",
        u"ずっと",
        u"すてき",
        u"すてる",
        u"すねる",
        u"すのこ",
        u"すはだ",
        u"すばらしい",
        u"ずひょう",
        u"ずぶぬれ",
        u"すぶり",
        u"すふれ",
        u"すべて",
        u"すべる",
        u"ずほう",
        u"すぼん",
        u"すまい",
        u"すめし",
        u"すもう",
        u"すやき",
        u"すらすら",
        u"するめ",
        u"すれちがう",
        u"すろっと",
        u"すわる",
        u"すんぜん",
        u"すんぽう",
        u"せあぶら",
        u"せいかつ",
        u"せいげん",
        u"せいじ",
        u"せいよう",
        u"せおう",
        u"せかいかん",
        u"せきにん",
        u"せきむ",
        u"せきゆ",
        u"せきらんうん",
        u"せけん",
        u"せこう",
        u"せすじ",
        u"せたい",
        u"せたけ",
        u"せっかく",
        u"せっきゃく",
        u"ぜっく",
        u"せっけん",
        u"せっこつ",
        u"せっさたくま",
        u"せつぞく",
        u"せつだん",
        u"せつでん",
        u"せっぱん",
        u"せつび",
        u"せつぶん",
        u"せつめい",
        u"せつりつ",
        u"せなか",
        u"せのび",
        u"せはば",
        u"せびろ",
        u"せぼね",
        u"せまい",
        u"せまる",
        u"せめる",
        u"せもたれ",
        u"せりふ",
        u"ぜんあく",
        u"せんい",
        u"せんえい",
        u"せんか",
        u"せんきょ",
        u"せんく",
        u"せんげん",
        u"ぜんご",
        u"せんさい",
        u"せんしゅ",
        u"せんすい",
        u"せんせい",
        u"せんぞ",
        u"せんたく",
        u"せんちょう",
        u"せんてい",
        u"せんとう",
        u"せんぬき",
        u"せんねん",
        u"せんぱい",
        u"ぜんぶ",
        u"ぜんぽう",
        u"せんむ",
        u"せんめんじょ",
        u"せんもん",
        u"せんやく",
        u"せんゆう",
        u"せんよう",
        u"ぜんら",
        u"ぜんりゃく",
        u"せんれい",
        u"せんろ",
        u"そあく",
        u"そいとげる",
        u"そいね",
        u"そうがんきょう",
        u"そうき",
        u"そうご",
        u"そうしん",
        u"そうだん",
        u"そうなん",
        u"そうび",
        u"そうめん",
        u"そうり",
        u"そえもの",
        u"そえん",
        u"そがい",
        u"そげき",
        u"そこう",
        u"そこそこ",
        u"そざい",
        u"そしな",
        u"そせい",
        u"そせん",
        u"そそぐ",
        u"そだてる",
        u"そつう",
        u"そつえん",
        u"そっかん",
        u"そつぎょう",
        u"そっけつ",
        u"そっこう",
        u"そっせん",
        u"そっと",
        u"そとがわ",
        u"そとづら",
        u"そなえる",
        u"そなた",
        u"そふぼ",
        u"そぼく",
        u"そぼろ",
        u"そまつ",
        u"そまる",
        u"そむく",
        u"そむりえ",
        u"そめる",
        u"そもそも",
        u"そよかぜ",
        u"そらまめ",
        u"そろう",
        u"そんかい",
        u"そんけい",
        u"そんざい",
        u"そんしつ",
        u"そんぞく",
        u"そんちょう",
        u"ぞんび",
        u"ぞんぶん",
        u"そんみん",
        u"たあい",
        u"たいいん",
        u"たいうん",
        u"たいえき",
        u"たいおう",
        u"だいがく",
        u"たいき",
        u"たいぐう",
        u"たいけん",
        u"たいこ",
        u"たいざい",
        u"だいじょうぶ",
        u"だいすき",
        u"たいせつ",
        u"たいそう",
        u"だいたい",
        u"たいちょう",
        u"たいてい",
        u"だいどころ",
        u"たいない",
        u"たいねつ",
        u"たいのう",
        u"たいはん",
        u"だいひょう",
        u"たいふう",
        u"たいへん",
        u"たいほ",
        u"たいまつばな",
        u"たいみんぐ",
        u"たいむ",
        u"たいめん",
        u"たいやき",
        u"たいよう",
        u"たいら",
        u"たいりょく",
        u"たいる",
        u"たいわん",
        u"たうえ",
        u"たえる",
        u"たおす",
        u"たおる",
        u"たおれる",
        u"たかい",
        u"たかね",
        u"たきび",
        u"たくさん",
        u"たこく",
        u"たこやき",
        u"たさい",
        u"たしざん",
        u"だじゃれ",
        u"たすける",
        u"たずさわる",
        u"たそがれ",
        u"たたかう",
        u"たたく",
        u"ただしい",
        u"たたみ",
        u"たちばな",
        u"だっかい",
        u"だっきゃく",
        u"だっこ",
        u"だっしゅつ",
        u"だったい",
        u"たてる",
        u"たとえる",
        u"たなばた",
        u"たにん",
        u"たぬき",
        u"たのしみ",
        u"たはつ",
        u"たぶん",
        u"たべる",
        u"たぼう",
        u"たまご",
        u"たまる",
        u"だむる",
        u"ためいき",
        u"ためす",
        u"ためる",
        u"たもつ",
        u"たやすい",
        u"たよる",
        u"たらす",
        u"たりきほんがん",
        u"たりょう",
        u"たりる",
        u"たると",
        u"たれる",
        u"たれんと",
        u"たろっと",
        u"たわむれる",
        u"だんあつ",
        u"たんい",
        u"たんおん",
        u"たんか",
        u"たんき",
        u"たんけん",
        u"たんご",
        u"たんさん",
        u"たんじょうび",
        u"だんせい",
        u"たんそく",
        u"たんたい",
        u"だんち",
        u"たんてい",
        u"たんとう",
        u"だんな",
        u"たんにん",
        u"だんねつ",
        u"たんのう",
        u"たんぴん",
        u"だんぼう",
        u"たんまつ",
        u"たんめい",
        u"だんれつ",
        u"だんろ",
        u"だんわ",
        u"ちあい",
        u"ちあん",
        u"ちいき",
        u"ちいさい",
        u"ちえん",
        u"ちかい",
        u"ちから",
        u"ちきゅう",
        u"ちきん",
        u"ちけいず",
        u"ちけん",
        u"ちこく",
        u"ちさい",
        u"ちしき",
        u"ちしりょう",
        u"ちせい",
        u"ちそう",
        u"ちたい",
        u"ちたん",
        u"ちちおや",
        u"ちつじょ",
        u"ちてき",
        u"ちてん",
        u"ちぬき",
        u"ちぬり",
        u"ちのう",
        u"ちひょう",
        u"ちへいせん",
        u"ちほう",
        u"ちまた",
        u"ちみつ",
        u"ちみどろ",
        u"ちめいど",
        u"ちゃんこなべ",
        u"ちゅうい",
        u"ちゆりょく",
        u"ちょうし",
        u"ちょさくけん",
        u"ちらし",
        u"ちらみ",
        u"ちりがみ",
        u"ちりょう",
        u"ちるど",
        u"ちわわ",
        u"ちんたい",
        u"ちんもく",
        u"ついか",
        u"ついたち",
        u"つうか",
        u"つうじょう",
        u"つうはん",
        u"つうわ",
        u"つかう",
        u"つかれる",
        u"つくね",
        u"つくる",
        u"つけね",
        u"つける",
        u"つごう",
        u"つたえる",
        u"つづく",
        u"つつじ",
        u"つつむ",
        u"つとめる",
        u"つながる",
        u"つなみ",
        u"つねづね",
        u"つのる",
        u"つぶす",
        u"つまらない",
        u"つまる",
        u"つみき",
        u"つめたい",
        u"つもり",
        u"つもる",
        u"つよい",
        u"つるぼ",
        u"つるみく",
        u"つわもの",
        u"つわり",
        u"てあし",
        u"てあて",
        u"てあみ",
        u"ていおん",
        u"ていか",
        u"ていき",
        u"ていけい",
        u"ていこく",
        u"ていさつ",
        u"ていし",
        u"ていせい",
        u"ていたい",
        u"ていど",
        u"ていねい",
        u"ていひょう",
        u"ていへん",
        u"ていぼう",
        u"てうち",
        u"ておくれ",
        u"てきとう",
        u"てくび",
        u"でこぼこ",
        u"てさぎょう",
        u"てさげ",
        u"てすり",
        u"てそう",
        u"てちがい",
        u"てちょう",
        u"てつがく",
        u"てつづき",
        u"でっぱ",
        u"てつぼう",
        u"てつや",
        u"でぬかえ",
        u"てぬき",
        u"てぬぐい",
        u"てのひら",
        u"てはい",
        u"てぶくろ",
        u"てふだ",
        u"てほどき",
        u"てほん",
        u"てまえ",
        u"てまきずし",
        u"てみじか",
        u"てみやげ",
        u"てらす",
        u"てれび",
        u"てわけ",
        u"てわたし",
        u"でんあつ",
        u"てんいん",
        u"てんかい",
        u"てんき",
        u"てんぐ",
        u"てんけん",
        u"てんごく",
        u"てんさい",
        u"てんし",
        u"てんすう",
        u"でんち",
        u"てんてき",
        u"てんとう",
        u"てんない",
        u"てんぷら",
        u"てんぼうだい",
        u"てんめつ",
        u"てんらんかい",
        u"でんりょく",
        u"でんわ",
        u"どあい",
        u"といれ",
        u"どうかん",
        u"とうきゅう",
        u"どうぐ",
        u"とうし",
        u"とうむぎ",
        u"とおい",
        u"とおか",
        u"とおく",
        u"とおす",
        u"とおる",
        u"とかい",
        u"とかす",
        u"ときおり",
        u"ときどき",
        u"とくい",
        u"とくしゅう",
        u"とくてん",
        u"とくに",
        u"とくべつ",
        u"とけい",
        u"とける",
        u"とこや",
        u"とさか",
        u"としょかん",
        u"とそう",
        u"とたん",
        u"とちゅう",
        u"とっきゅう",
        u"とっくん",
        u"とつぜん",
        u"とつにゅう",
        u"とどける",
        u"ととのえる",
        u"とない",
        u"となえる",
        u"となり",
        u"とのさま",
        u"とばす",
        u"どぶがわ",
        u"とほう",
        u"とまる",
        u"とめる",
        u"ともだち",
        u"ともる",
        u"どようび",
        u"とらえる",
        u"とんかつ",
        u"どんぶり",
        u"ないかく",
        u"ないこう",
        u"ないしょ",
        u"ないす",
        u"ないせん",
        u"ないそう",
        u"なおす",
        u"ながい",
        u"なくす",
        u"なげる",
        u"なこうど",
        u"なさけ",
        u"なたでここ",
        u"なっとう",
        u"なつやすみ",
        u"ななおし",
        u"なにごと",
        u"なにもの",
        u"なにわ",
        u"なのか",
        u"なふだ",
        u"なまいき",
        u"なまえ",
        u"なまみ",
        u"なみだ",
        u"なめらか",
        u"なめる",
        u"なやむ",
        u"ならう",
        u"ならび",
        u"ならぶ",
        u"なれる",
        u"なわとび",
        u"なわばり",
        u"にあう",
        u"にいがた",
        u"にうけ",
        u"におい",
        u"にかい",
        u"にがて",
        u"にきび",
        u"にくしみ",
        u"にくまん",
        u"にげる",
        u"にさんかたんそ",
        u"にしき",
        u"にせもの",
        u"にちじょう",
        u"にちようび",
        u"にっか",
        u"にっき",
        u"にっけい",
        u"にっこう",
        u"にっさん",
        u"にっしょく",
        u"にっすう",
        u"にっせき",
        u"にってい",
        u"になう",
        u"にほん",
        u"にまめ",
        u"にもつ",
        u"にやり",
        u"にゅういん",
        u"にりんしゃ",
        u"にわとり",
        u"にんい",
        u"にんか",
        u"にんき",
        u"にんげん",
        u"にんしき",
        u"にんずう",
        u"にんそう",
        u"にんたい",
        u"にんち",
        u"にんてい",
        u"にんにく",
        u"にんぷ",
        u"にんまり",
        u"にんむ",
        u"にんめい",
        u"にんよう",
        u"ぬいくぎ",
        u"ぬかす",
        u"ぬぐいとる",
        u"ぬぐう",
        u"ぬくもり",
        u"ぬすむ",
        u"ぬまえび",
        u"ぬめり",
        u"ぬらす",
        u"ぬんちゃく",
        u"ねあげ",
        u"ねいき",
        u"ねいる",
        u"ねいろ",
        u"ねぐせ",
        u"ねくたい",
        u"ねくら",
        u"ねこぜ",
        u"ねこむ",
        u"ねさげ",
        u"ねすごす",
        u"ねそべる",
        u"ねだん",
        u"ねつい",
        u"ねっしん",
        u"ねつぞう",
        u"ねったいぎょ",
        u"ねぶそく",
        u"ねふだ",
        u"ねぼう",
        u"ねほりはほり",
        u"ねまき",
        u"ねまわし",
        u"ねみみ",
        u"ねむい",
        u"ねむたい",
        u"ねもと",
        u"ねらう",
        u"ねわざ",
        u"ねんいり",
        u"ねんおし",
        u"ねんかん",
        u"ねんきん",
        u"ねんぐ",
        u"ねんざ",
        u"ねんし",
        u"ねんちゃく",
        u"ねんど",
        u"ねんぴ",
        u"ねんぶつ",
        u"ねんまつ",
        u"ねんりょう",
        u"ねんれい",
        u"のいず",
        u"のおづま",
        u"のがす",
        u"のきなみ",
        u"のこぎり",
        u"のこす",
        u"のこる",
        u"のせる",
        u"のぞく",
        u"のぞむ",
        u"のたまう",
        u"のちほど",
        u"のっく",
        u"のばす",
        u"のはら",
        u"のべる",
        u"のぼる",
        u"のみもの",
        u"のやま",
        u"のらいぬ",
        u"のらねこ",
        u"のりもの",
        u"のりゆき",
        u"のれん",
        u"のんき",
        u"ばあい",
        u"はあく",
        u"ばあさん",
        u"ばいか",
        u"ばいく",
        u"はいけん",
        u"はいご",
        u"はいしん",
        u"はいすい",
        u"はいせん",
        u"はいそう",
        u"はいち",
        u"ばいばい",
        u"はいれつ",
        u"はえる",
        u"はおる",
        u"はかい",
        u"ばかり",
        u"はかる",
        u"はくしゅ",
        u"はけん",
        u"はこぶ",
        u"はさみ",
        u"はさん",
        u"はしご",
        u"ばしょ",
        u"はしる",
        u"はせる",
        u"ぱそこん",
        u"はそん",
        u"はたん",
        u"はちみつ",
        u"はつおん",
        u"はっかく",
        u"はづき",
        u"はっきり",
        u"はっくつ",
        u"はっけん",
        u"はっこう",
        u"はっさん",
        u"はっしん",
        u"はったつ",
        u"はっちゅう",
        u"はってん",
        u"はっぴょう",
        u"はっぽう",
        u"はなす",
        u"はなび",
        u"はにかむ",
        u"はぶらし",
        u"はみがき",
        u"はむかう",
        u"はめつ",
        u"はやい",
        u"はやし",
        u"はらう",
        u"はろうぃん",
        u"はわい",
        u"はんい",
        u"はんえい",
        u"はんおん",
        u"はんかく",
        u"はんきょう",
        u"ばんぐみ",
        u"はんこ",
        u"はんしゃ",
        u"はんすう",
        u"はんだん",
        u"ぱんち",
        u"ぱんつ",
        u"はんてい",
        u"はんとし",
        u"はんのう",
        u"はんぱ",
        u"はんぶん",
        u"はんぺん",
        u"はんぼうき",
        u"はんめい",
        u"はんらん",
        u"はんろん",
        u"ひいき",
        u"ひうん",
        u"ひえる",
        u"ひかく",
        u"ひかり",
        u"ひかる",
        u"ひかん",
        u"ひくい",
        u"ひけつ",
        u"ひこうき",
        u"ひこく",
        u"ひさい",
        u"ひさしぶり",
        u"ひさん",
        u"びじゅつかん",
        u"ひしょ",
    ]
