"""
Common DTOs for notification system used by both Client SDK and Manager.
"""

from __future__ import annotations

from .request import (
    CreateNotificationChannelRequest,
    CreateNotificationRuleRequest,
    ListNotificationChannelsRequest,
    ListNotificationRulesRequest,
    NotificationChannelFilter,
    NotificationChannelOrder,
    NotificationRuleFilter,
    NotificationRuleOrder,
    SearchNotificationChannelsRequest,
    SearchNotificationRulesRequest,
    StringFilter,
    UpdateNotificationChannelRequest,
    UpdateNotificationRuleRequest,
    ValidateNotificationChannelRequest,
    ValidateNotificationRuleRequest,
)
from .response import (
    CreateNotificationChannelResponse,
    CreateNotificationRuleResponse,
    DeleteNotificationChannelResponse,
    DeleteNotificationRuleResponse,
    GetNotificationChannelResponse,
    GetNotificationRuleResponse,
    ListNotificationChannelsResponse,
    ListNotificationRulesResponse,
    ListNotificationRuleTypesResponse,
    NotificationChannelDTO,
    NotificationRuleDTO,
    NotificationRuleTypeSchemaResponse,
    PaginationInfo,
    UpdateNotificationChannelResponse,
    UpdateNotificationRuleResponse,
    ValidateNotificationChannelResponse,
    ValidateNotificationRuleResponse,
    WebhookConfigResponse,
)
from .types import (
    NotificationChannelOrderField,
    NotificationChannelType,
    NotificationRuleOrderField,
    NotificationRuleType,
    OrderDirection,
    WebhookConfig,
)

__all__ = (
    # Types
    "NotificationChannelType",
    "NotificationRuleType",
    "WebhookConfig",
    "OrderDirection",
    "NotificationChannelOrderField",
    "NotificationRuleOrderField",
    # Request DTOs
    "CreateNotificationChannelRequest",
    "UpdateNotificationChannelRequest",
    "ListNotificationChannelsRequest",
    "SearchNotificationChannelsRequest",
    "CreateNotificationRuleRequest",
    "UpdateNotificationRuleRequest",
    "ListNotificationRulesRequest",
    "SearchNotificationRulesRequest",
    "ValidateNotificationChannelRequest",
    "ValidateNotificationRuleRequest",
    "StringFilter",
    "NotificationChannelFilter",
    "NotificationRuleFilter",
    "NotificationChannelOrder",
    "NotificationRuleOrder",
    # Response DTOs
    "WebhookConfigResponse",
    "NotificationChannelDTO",
    "NotificationRuleDTO",
    "CreateNotificationChannelResponse",
    "UpdateNotificationChannelResponse",
    "DeleteNotificationChannelResponse",
    "GetNotificationChannelResponse",
    "ListNotificationChannelsResponse",
    "CreateNotificationRuleResponse",
    "UpdateNotificationRuleResponse",
    "DeleteNotificationRuleResponse",
    "GetNotificationRuleResponse",
    "ListNotificationRulesResponse",
    "ListNotificationRuleTypesResponse",
    "NotificationRuleTypeSchemaResponse",
    "ValidateNotificationChannelResponse",
    "ValidateNotificationRuleResponse",
    "PaginationInfo",
)
