
# DO NOT EDIT THIS FILE -- AUTOGENERATED BY PANTS
# Target: src/ai/backend/common:dist

from setuptools import setup

setup(**{
    'author': 'Lablup Inc. and contributors',
    'classifiers': [
        'Intended Audience :: Developers',
        'Operating System :: MacOS :: MacOS X',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Environment :: No Input/Output (Daemon)',
        'Topic :: Scientific/Engineering',
        'Topic :: Software Development',
        'Development Status :: 4 - Beta',
        'Programming Language :: Python :: 3.13',
        'License :: OSI Approved :: GNU Lesser General Public License v3 or later (LGPLv3+)',
    ],
    'description': 'Backend.AI commons library',
    'install_requires': (
        'PyJWT~=2.10.1',
        'aiodns==3.2',
        'aiofiles~=24.1.0',
        'aiohttp~=3.12.15',
        'aiomonitor~=0.7.0',
        'aiotools~=2.2.3',
        'async_timeout~=4.0',
        'asynctest>=0.13.0',
        'asyncudp>=0.11',
        'attrs>=25.3',
        """backend.ai-logging==25.17.0rc1
""",
        """backend.ai-plugin==25.17.0rc1
""",
        'callosum~=1.0.3',
        'click~=8.1.7',
        'etcd-client-py~=0.4.1',
        'graphql-core~=3.2.6',
        'hiredis>=3.0.0',
        'ifaddr~=0.2',
        'janus~=2.0',
        'lark~=1.1.5',
        'msgpack~=1.1.0',
        'multidict~=6.6.4',
        'orjson~=3.10.16',
        'packaging>=24.1',
        'prometheus-client~=0.21.1',
        'psutil~=7.0',
        'pydantic[email]~=2.11.3',
        'pyhumps~=3.8.0',
        'pyroscope-io~=0.8.8',
        'python-dateutil>=2.9',
        'redis[hiredis]==4.5.5',
        'temporenc~=0.1.0',
        'tenacity>=9.0',
        'tomli~=2.0.1',
        'toml~=0.10.2',
        'trafaret~=2.1',
        'typeguard~=4.3',
        'types-aiofiles',
        'types-psutil',
        'types-python-dateutil',
        'types-redis',
        'types-six',
        'types-toml',
        'valkey-glide~=2.0.1',
        'yarl~=1.19.0',
    ),
    'license': 'LGPLv3',
    'long_description': """Backend.AI Common Package
=========================

← [Back to Backend.AI Architecture](../README.md)

[![PyPI release version](https://badge.fury.io/py/backend.ai-common.svg)](https://pypi.org/project/backend.ai-common/)
![Supported Python versions](https://img.shields.io/pypi/pyversions/backend.ai-common.svg)
[![Gitter](https://badges.gitter.im/lablup/backend.ai-common.svg)](https://gitter.im/lablup/backend.ai-common)

## Overview

The Backend.AI Common package provides utilities, infrastructure, and shared components used across all Backend.AI components (Manager, Agent, Storage Proxy, Webserver, App Proxy, etc.).

## Package Structure

### Entry Point System

Core event-based communication and asynchronous task processing framework for Backend.AI.

- **[events/](./events/README.md)** - Event Dispatcher System
  - Asynchronous event-based communication between components
  - Broadcast and Anycast event type support
  - Message queue-based event delivery
  - Event handler registration and routing

- **[bgtask/](./bgtask/README.md)** - Background Task Handler System
  - Process long-running tasks asynchronously
  - Issue Task IDs and track tasks
  - Progress monitoring and Heartbeat
  - Notify via event publishing upon completion

### Infrastructure Components

Client and abstraction layer for integration with external services and systems.

- **clients/** - External service client wrappers
  - Agent client (ZeroMQ RPC)
  - Storage Proxy client (HTTP)
  - Valkey/Redis client
  - etcd client

- **message_queue/** - Message queue interface and implementation
  - Provide message publish/subscribe interface
  - Currently implemented based on Redis Streams
  - Consumer Group management
  - Future support for other message queue systems planned

- **service_discovery/** - Service registration and integration
  - etcd-based service registration and discovery
  - Provide service information for Prometheus metrics collection
  - Automatic health check and update
  - Future expansion of additional service discovery features planned

- **resilience/** - Inter-layer communication resilience patterns
  - Generalize request processing between layers
  - Retry, Timeout, Circuit Breaker
  - Automatic metric collection
  - Fallback support

### Data and Types

Common structures for data exchange and type definitions between components.

- **dto/** - Data Transfer Objects (for inter-component communication)
  - Data structures used for inter-component communication
  - Request/Response models
  - Event payloads
  - Recommended to use Pydantic-based

- **types.py** - Common type definitions (for internal logic)
  - Domain types used within components (SessionId, AgentId, AccessKey, etc.)
  - Shared Enum types
  - Common constants
  - Mainly used in internal business logic

### Utilities

Utility modules for development convenience and common functionality.

- **metrics/** - Metrics collection and Prometheus integration
  - Metric observer pattern
  - Prometheus metric types (Counter, Gauge, Histogram)
  - HTTP metrics middleware

- **auth/** - Authentication utilities
  - Authentication between Webserver (Gateway) and Manager
  - JWT token generation/verification
  - Signature generation/verification
  - API Key management

- **web/** - Web utilities
  - HTTP helper functions
  - CORS configuration
  - Request/response processing

- **middlewares/** - Common middlewares
  - Commonly used across all components
  - Authentication middleware
  - Logging middleware
  - Error handling middleware

- **configs/** - Configuration management utilities
  - Configuration processing commonly used internally
  - Configuration file parsing (TOML, YAML)
  - Environment variable processing
  - Configuration validation

### Other Components

- **contexts/** - Context management utilities
  - ContextVar-based request and user tracking
  - Current request ID tracking
  - Current user information management
  - Context propagation

- **data/** - Common data utilities
  - Data-based value processing used in internal logic
  - Data transformation and validation
  - Common data type handling

- **exception.py** - Common exception classes
  - Base exceptions for all Backend.AI services
  - Exception definitions must inherit from BackendAIError
  - Domain-specific exception classes
  - Communicate error situations externally

- **utils.py** - Other utility functions
  - String processing
  - Time conversion
  - Other helper functions

## Installation

```console
$ pip install backend.ai-common
```

## For development

```console
$ pip install -U pip setuptools
$ pip install -U -r requirements/dev.txt
```

### Running test suite

```console
$ python -m pytest
```

With the default halfstack setup, you may need to set the environment variable `BACKEND_ETCD_ADDR`
to specify the non-standard etcd service port (e.g., `localhost:8110`).

The tests for `common.redis` module requires availability of local TCP ports 16379, 16380, 16381,
26379, 26380, and 26381 to launch a temporary Redis sentinel cluster via `docker compose`.

In macOS, they require a local `redis-server` executable to be installed, preferably via `brew`,
because `docker compose` in macOS does not support host-mode networking and Redis *cannot* be
configured to use different self IP addresses to announce to the cluster nodes and clients.

## Related Documentation

- [Event Dispatcher System](./events/README.md)
- [Background Task Handler System](./bgtask/README.md)
- [Manager Component](../manager/README.md)
- [Agent Component](../agent/README.md)
- [Storage Proxy Component](../storage/README.md)
""",
    'long_description_content_type': 'text/markdown',
    'name': 'backend.ai-common',
    'namespace_packages': (
    ),
    'package_data': {
        'ai.backend.common': (
            'VERSION',
            'py.typed',
        ),
        'ai.backend.common.plugin': (
            'py.typed',
        ),
    },
    'packages': (
        'ai.backend.common',
        'ai.backend.common.auth',
        'ai.backend.common.bgtask',
        'ai.backend.common.bgtask.hooks',
        'ai.backend.common.bgtask.task',
        'ai.backend.common.clients',
        'ai.backend.common.clients.http_client',
        'ai.backend.common.clients.valkey_client',
        'ai.backend.common.clients.valkey_client.valkey_artifact',
        'ai.backend.common.clients.valkey_client.valkey_bgtask',
        'ai.backend.common.clients.valkey_client.valkey_container_log',
        'ai.backend.common.clients.valkey_client.valkey_leader',
        'ai.backend.common.clients.valkey_client.valkey_live',
        'ai.backend.common.clients.valkey_client.valkey_rate_limit',
        'ai.backend.common.clients.valkey_client.valkey_schedule',
        'ai.backend.common.clients.valkey_client.valkey_session',
        'ai.backend.common.clients.valkey_client.valkey_stat',
        'ai.backend.common.clients.valkey_client.valkey_stream',
        'ai.backend.common.configs',
        'ai.backend.common.contexts',
        'ai.backend.common.data',
        'ai.backend.common.data.agent',
        'ai.backend.common.data.artifact',
        'ai.backend.common.data.bgtask',
        'ai.backend.common.data.config',
        'ai.backend.common.data.endpoint',
        'ai.backend.common.data.image',
        'ai.backend.common.data.model_deployment',
        'ai.backend.common.data.notification',
        'ai.backend.common.data.session',
        'ai.backend.common.data.storage',
        'ai.backend.common.data.storage.registries',
        'ai.backend.common.data.user',
        'ai.backend.common.data.vfolder',
        'ai.backend.common.defs',
        'ai.backend.common.dto.agent',
        'ai.backend.common.dto.manager',
        'ai.backend.common.dto.manager.auth',
        'ai.backend.common.dto.manager.notification',
        'ai.backend.common.dto.storage',
        'ai.backend.common.events',
        'ai.backend.common.events.event_types',
        'ai.backend.common.events.event_types.agent',
        'ai.backend.common.events.event_types.artifact',
        'ai.backend.common.events.event_types.artifact_registry',
        'ai.backend.common.events.event_types.bgtask',
        'ai.backend.common.events.event_types.idle',
        'ai.backend.common.events.event_types.image',
        'ai.backend.common.events.event_types.kernel',
        'ai.backend.common.events.event_types.log',
        'ai.backend.common.events.event_types.model_serving',
        'ai.backend.common.events.event_types.notification',
        'ai.backend.common.events.event_types.schedule',
        'ai.backend.common.events.event_types.session',
        'ai.backend.common.events.event_types.vfolder',
        'ai.backend.common.events.event_types.volume',
        'ai.backend.common.events.hub',
        'ai.backend.common.events.hub.propagators',
        'ai.backend.common.events.user_event',
        'ai.backend.common.jwt',
        'ai.backend.common.leader',
        'ai.backend.common.leader.tasks',
        'ai.backend.common.log',
        'ai.backend.common.message_queue',
        'ai.backend.common.message_queue.abc',
        'ai.backend.common.message_queue.redis_queue',
        'ai.backend.common.metrics',
        'ai.backend.common.middlewares',
        'ai.backend.common.models.minilang',
        'ai.backend.common.observer',
        'ai.backend.common.plugin',
        'ai.backend.common.resilience',
        'ai.backend.common.resilience.policies',
        'ai.backend.common.resource',
        'ai.backend.common.runner',
        'ai.backend.common.service_discovery',
        'ai.backend.common.service_discovery.etcd_discovery',
        'ai.backend.common.service_discovery.redis_discovery',
        'ai.backend.common.stage',
        'ai.backend.common.type_adapters',
        'ai.backend.common.web.session',
    ),
    'project_urls': {
        'Documentation': 'https://docs.backend.ai/',
        'Source': 'https://github.com/lablup/backend.ai',
    },
    'python_requires': '>=3.13,<3.14',
    'url': 'https://github.com/lablup/backend.ai',
    'version': """25.17.0rc1
""",
    'zip_safe': False,
})
