/* File: bslz4_to_sparsemodule.c
 * This file is auto-generated with f2py (version:1.21.0).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Mar  7 08:26:52 2023
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *bslz4_to_sparse_error;
static PyObject *bslz4_to_sparse_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef unsigned char unsigned_char;
typedef unsigned short unsigned_short;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(bslz4_to_sparse_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = bslz4_to_sparse_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern int bslz4_u16(unsigned_char*,int,unsigned_char*,int,unsigned_short*,unsigned*,int);
extern int bslz4_u32(unsigned_char*,int,unsigned_char*,int,unsigned*,unsigned*,int);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************************* bslz4_u16 *********************************/
static char doc_f2py_rout_bslz4_to_sparse_bslz4_u16[] = "\
bslz4_u16 = bslz4_u16(cmp,msk,out,outP,thresh)\n\nWrapper for ``bslz4_u16``.\
\n\nParameters\n----------\n"
"cmp : input rank-1 array('B') with bounds (cmpN)\n"
"msk : input rank-1 array('B') with bounds (NIJ)\n"
"out : in/output rank-1 array('H') with bounds (NIJ)\n"
"outP : in/output rank-1 array('I') with bounds (NIJ)\n"
"thresh : input int\n"
"\nReturns\n-------\n"
"bslz4_u16 : int";
/* extern int bslz4_u16(unsigned_char*,int,unsigned_char*,int,unsigned_short*,unsigned*,int); */
static PyObject *f2py_rout_bslz4_to_sparse_bslz4_u16(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           int (*f2py_func)(unsigned_char*,int,unsigned_char*,int,unsigned_short*,unsigned*,int)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int bslz4_u16_return_value=0;
  unsigned_char *cmp = NULL;
  npy_intp cmp_Dims[1] = {-1};
  const int cmp_Rank = 1;
  PyArrayObject *capi_cmp_tmp = NULL;
  int capi_cmp_intent = 0;
  PyObject *cmp_capi = Py_None;
  int cmpN = 0;
  unsigned_char *msk = NULL;
  npy_intp msk_Dims[1] = {-1};
  const int msk_Rank = 1;
  PyArrayObject *capi_msk_tmp = NULL;
  int capi_msk_intent = 0;
  PyObject *msk_capi = Py_None;
  int NIJ = 0;
  unsigned_short *out = NULL;
  npy_intp out_Dims[1] = {-1};
  const int out_Rank = 1;
  PyArrayObject *capi_out_tmp = NULL;
  int capi_out_intent = 0;
  PyObject *out_capi = Py_None;
  unsigned *outP = NULL;
  npy_intp outP_Dims[1] = {-1};
  const int outP_Rank = 1;
  PyArrayObject *capi_outP_tmp = NULL;
  int capi_outP_intent = 0;
  PyObject *outP_capi = Py_None;
  int thresh = 0;
  PyObject *thresh_capi = Py_None;
    static char *capi_kwlist[] = {"cmp","msk","out","outP","thresh",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:bslz4_to_sparse.bslz4_u16",\
        capi_kwlist,&cmp_capi,&msk_capi,&out_capi,&outP_capi,&thresh_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable cmp */
  ;
  capi_cmp_intent |= F2PY_INTENT_IN|F2PY_INTENT_C;
  capi_cmp_tmp = array_from_pyobj(NPY_UBYTE,cmp_Dims,cmp_Rank,capi_cmp_intent,cmp_capi);
  if (capi_cmp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 1st argument `cmp' of bslz4_to_sparse.bslz4_u16 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cmp = (unsigned_char *)(PyArray_DATA(capi_cmp_tmp));

  /* Processing variable msk */
  ;
  capi_msk_intent |= F2PY_INTENT_IN|F2PY_INTENT_C;
  capi_msk_tmp = array_from_pyobj(NPY_UBYTE,msk_Dims,msk_Rank,capi_msk_intent,msk_capi);
  if (capi_msk_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 2nd argument `msk' of bslz4_to_sparse.bslz4_u16 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    msk = (unsigned_char *)(PyArray_DATA(capi_msk_tmp));

  /* Processing variable thresh */
    f2py_success = int_from_pyobj(&thresh,thresh_capi,"bslz4_to_sparse.bslz4_u16() 5th argument (thresh) can't be converted to int");
  if (f2py_success) {
  /* Processing variable cmpN */
  cmpN = len(cmp);
  CHECKSCALAR(len(cmp)>=cmpN,"len(cmp)>=cmpN","hidden cmpN","bslz4_u16:cmpN=%d",cmpN) {
  /* Processing variable NIJ */
  NIJ = len(msk);
  CHECKSCALAR(len(msk)>=NIJ,"len(msk)>=NIJ","hidden NIJ","bslz4_u16:NIJ=%d",NIJ) {
  /* Processing variable out */
  out_Dims[0]=NIJ;
  capi_out_intent |= F2PY_INTENT_INOUT|F2PY_INTENT_C;
  capi_out_tmp = array_from_pyobj(NPY_USHORT,out_Dims,out_Rank,capi_out_intent,out_capi);
  if (capi_out_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 3rd argument `out' of bslz4_to_sparse.bslz4_u16 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    out = (unsigned_short *)(PyArray_DATA(capi_out_tmp));

  /* Processing variable outP */
  outP_Dims[0]=NIJ;
  capi_outP_intent |= F2PY_INTENT_INOUT|F2PY_INTENT_C;
  capi_outP_tmp = array_from_pyobj(NPY_UINT,outP_Dims,outP_Rank,capi_outP_intent,outP_capi);
  if (capi_outP_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 4th argument `outP' of bslz4_to_sparse.bslz4_u16 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    outP = (unsigned *)(PyArray_DATA(capi_outP_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  Py_BEGIN_ALLOW_THREADS
  bslz4_u16_return_value = (*f2py_func)(cmp,cmpN,msk,NIJ,out,outP,thresh);
  Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("i",bslz4_u16_return_value);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_outP_tmp!=outP_capi) {
    Py_XDECREF(capi_outP_tmp); }
  }  /*if (capi_outP_tmp == NULL) ... else of outP*/
  /* End of cleaning variable outP */
  if((PyObject *)capi_out_tmp!=out_capi) {
    Py_XDECREF(capi_out_tmp); }
  }  /*if (capi_out_tmp == NULL) ... else of out*/
  /* End of cleaning variable out */
  } /*CHECKSCALAR(len(msk)>=NIJ)*/
  /* End of cleaning variable NIJ */
  } /*CHECKSCALAR(len(cmp)>=cmpN)*/
  /* End of cleaning variable cmpN */
  } /*if (f2py_success) of thresh*/
  /* End of cleaning variable thresh */
  if((PyObject *)capi_msk_tmp!=msk_capi) {
    Py_XDECREF(capi_msk_tmp); }
  }  /*if (capi_msk_tmp == NULL) ... else of msk*/
  /* End of cleaning variable msk */
  if((PyObject *)capi_cmp_tmp!=cmp_capi) {
    Py_XDECREF(capi_cmp_tmp); }
  }  /*if (capi_cmp_tmp == NULL) ... else of cmp*/
  /* End of cleaning variable cmp */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of bslz4_u16 ******************************/

/********************************* bslz4_u32 *********************************/
static char doc_f2py_rout_bslz4_to_sparse_bslz4_u32[] = "\
bslz4_u32 = bslz4_u32(cmp,msk,out,outP,thresh)\n\nWrapper for ``bslz4_u32``.\
\n\nParameters\n----------\n"
"cmp : input rank-1 array('B') with bounds (cmpN)\n"
"msk : input rank-1 array('B') with bounds (NIJ)\n"
"out : in/output rank-1 array('I') with bounds (NIJ)\n"
"outP : in/output rank-1 array('I') with bounds (NIJ)\n"
"thresh : input int\n"
"\nReturns\n-------\n"
"bslz4_u32 : int";
/* extern int bslz4_u32(unsigned_char*,int,unsigned_char*,int,unsigned*,unsigned*,int); */
static PyObject *f2py_rout_bslz4_to_sparse_bslz4_u32(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           int (*f2py_func)(unsigned_char*,int,unsigned_char*,int,unsigned*,unsigned*,int)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  int bslz4_u32_return_value=0;
  unsigned_char *cmp = NULL;
  npy_intp cmp_Dims[1] = {-1};
  const int cmp_Rank = 1;
  PyArrayObject *capi_cmp_tmp = NULL;
  int capi_cmp_intent = 0;
  PyObject *cmp_capi = Py_None;
  int cmpN = 0;
  unsigned_char *msk = NULL;
  npy_intp msk_Dims[1] = {-1};
  const int msk_Rank = 1;
  PyArrayObject *capi_msk_tmp = NULL;
  int capi_msk_intent = 0;
  PyObject *msk_capi = Py_None;
  int NIJ = 0;
  unsigned *out = NULL;
  npy_intp out_Dims[1] = {-1};
  const int out_Rank = 1;
  PyArrayObject *capi_out_tmp = NULL;
  int capi_out_intent = 0;
  PyObject *out_capi = Py_None;
  unsigned *outP = NULL;
  npy_intp outP_Dims[1] = {-1};
  const int outP_Rank = 1;
  PyArrayObject *capi_outP_tmp = NULL;
  int capi_outP_intent = 0;
  PyObject *outP_capi = Py_None;
  int thresh = 0;
  PyObject *thresh_capi = Py_None;
    static char *capi_kwlist[] = {"cmp","msk","out","outP","thresh",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOO|:bslz4_to_sparse.bslz4_u32",\
        capi_kwlist,&cmp_capi,&msk_capi,&out_capi,&outP_capi,&thresh_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable cmp */
  ;
  capi_cmp_intent |= F2PY_INTENT_IN|F2PY_INTENT_C;
  capi_cmp_tmp = array_from_pyobj(NPY_UBYTE,cmp_Dims,cmp_Rank,capi_cmp_intent,cmp_capi);
  if (capi_cmp_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 1st argument `cmp' of bslz4_to_sparse.bslz4_u32 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cmp = (unsigned_char *)(PyArray_DATA(capi_cmp_tmp));

  /* Processing variable msk */
  ;
  capi_msk_intent |= F2PY_INTENT_IN|F2PY_INTENT_C;
  capi_msk_tmp = array_from_pyobj(NPY_UBYTE,msk_Dims,msk_Rank,capi_msk_intent,msk_capi);
  if (capi_msk_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 2nd argument `msk' of bslz4_to_sparse.bslz4_u32 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    msk = (unsigned_char *)(PyArray_DATA(capi_msk_tmp));

  /* Processing variable thresh */
    f2py_success = int_from_pyobj(&thresh,thresh_capi,"bslz4_to_sparse.bslz4_u32() 5th argument (thresh) can't be converted to int");
  if (f2py_success) {
  /* Processing variable cmpN */
  cmpN = len(cmp);
  CHECKSCALAR(len(cmp)>=cmpN,"len(cmp)>=cmpN","hidden cmpN","bslz4_u32:cmpN=%d",cmpN) {
  /* Processing variable NIJ */
  NIJ = len(msk);
  CHECKSCALAR(len(msk)>=NIJ,"len(msk)>=NIJ","hidden NIJ","bslz4_u32:NIJ=%d",NIJ) {
  /* Processing variable out */
  out_Dims[0]=NIJ;
  capi_out_intent |= F2PY_INTENT_INOUT|F2PY_INTENT_C;
  capi_out_tmp = array_from_pyobj(NPY_UINT,out_Dims,out_Rank,capi_out_intent,out_capi);
  if (capi_out_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 3rd argument `out' of bslz4_to_sparse.bslz4_u32 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    out = (unsigned *)(PyArray_DATA(capi_out_tmp));

  /* Processing variable outP */
  outP_Dims[0]=NIJ;
  capi_outP_intent |= F2PY_INTENT_INOUT|F2PY_INTENT_C;
  capi_outP_tmp = array_from_pyobj(NPY_UINT,outP_Dims,outP_Rank,capi_outP_intent,outP_capi);
  if (capi_outP_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : bslz4_to_sparse_error,"failed in converting 4th argument `outP' of bslz4_to_sparse.bslz4_u32 to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    outP = (unsigned *)(PyArray_DATA(capi_outP_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  Py_BEGIN_ALLOW_THREADS
  bslz4_u32_return_value = (*f2py_func)(cmp,cmpN,msk,NIJ,out,outP,thresh);
  Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("i",bslz4_u32_return_value);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_outP_tmp!=outP_capi) {
    Py_XDECREF(capi_outP_tmp); }
  }  /*if (capi_outP_tmp == NULL) ... else of outP*/
  /* End of cleaning variable outP */
  if((PyObject *)capi_out_tmp!=out_capi) {
    Py_XDECREF(capi_out_tmp); }
  }  /*if (capi_out_tmp == NULL) ... else of out*/
  /* End of cleaning variable out */
  } /*CHECKSCALAR(len(msk)>=NIJ)*/
  /* End of cleaning variable NIJ */
  } /*CHECKSCALAR(len(cmp)>=cmpN)*/
  /* End of cleaning variable cmpN */
  } /*if (f2py_success) of thresh*/
  /* End of cleaning variable thresh */
  if((PyObject *)capi_msk_tmp!=msk_capi) {
    Py_XDECREF(capi_msk_tmp); }
  }  /*if (capi_msk_tmp == NULL) ... else of msk*/
  /* End of cleaning variable msk */
  if((PyObject *)capi_cmp_tmp!=cmp_capi) {
    Py_XDECREF(capi_cmp_tmp); }
  }  /*if (capi_cmp_tmp == NULL) ... else of cmp*/
  /* End of cleaning variable cmp */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************************** end of bslz4_u32 ******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"bslz4_u16",-1,{{-1}},0,(char *)bslz4_u16,(f2py_init_func)f2py_rout_bslz4_to_sparse_bslz4_u16,doc_f2py_rout_bslz4_to_sparse_bslz4_u16},
  {"bslz4_u32",-1,{{-1}},0,(char *)bslz4_u32,(f2py_init_func)f2py_rout_bslz4_to_sparse_bslz4_u32,doc_f2py_rout_bslz4_to_sparse_bslz4_u32},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "bslz4_to_sparse",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_bslz4_to_sparse(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = bslz4_to_sparse_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module bslz4_to_sparse (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.21.0");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'bslz4_to_sparse' is auto-generated with f2py (version:1.21.0).\nFunctions:\n"
"  bslz4_u16 = bslz4_u16(cmp,msk,out,outP,thresh)\n"
"  bslz4_u32 = bslz4_u32(cmp,msk,out,outP,thresh)\n"
".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.21.0");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  bslz4_to_sparse_error = PyErr_NewException ("bslz4_to_sparse.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_bslz4_to_sparse_error", bslz4_to_sparse_error);
  Py_DECREF(bslz4_to_sparse_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }


/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"bslz4_to_sparse");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
