"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamKey = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("@aws-cdk/core");
const ivs_generated_1 = require("./ivs.generated");
/**
  A new IVS Stream Key
*/
class StreamKey extends core.Resource {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_StreamKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StreamKey);
            }
            throw error;
        }
        const resource = new ivs_generated_1.CfnStreamKey(this, 'Resource', {
            channelArn: props.channel.channelArn,
        });
        this.streamKeyArn = resource.attrArn;
        this.streamKeyValue = resource.attrValue;
    }
}
exports.StreamKey = StreamKey;
_a = JSII_RTTI_SYMBOL_1;
StreamKey[_a] = { fqn: "@aws-cdk/aws-ivs.StreamKey", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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