#################### Maintained by Hatch ####################
# This file is auto-generated by hatch. If you'd like to customize this file
# please add your changes near the bottom marked for 'USER OVERRIDES'.
# EVERYTHING ELSE WILL BE OVERWRITTEN by hatch.
#############################################################
from io import open

from setuptools import find_packages, setup

with open('ryo_iso/__init__.py', 'r') as f:
    for line in f:
        if line.startswith('__version__'):
            version = line.strip().split('=')[1].strip(' \'"')
            break
    else:
        version = '0.0.1'

with open('README.md', 'r', encoding='utf-8') as f:
    readme = f.read()

REQUIRES = [
    'appdirs',
    'loguru',
    'pyyaml',
    'requests',
    'delegator.py',
    'doit',
    'importlib_resources',
    'tqdm',
]

kwargs = {
    'name': 'ryo-iso',
    'version': version,
    'description': '',
    'long_description': readme,
    'long_description_content_type': 'text/markdown',
    'author': 'HXR',
    'author_email': 'code@hxr.io',
    'maintainer': 'HXR',
    'maintainer_email': 'code@hxr.io',
    'url': 'https://git.sr.ht/~lucidone/ryo-iso',
    'license': 'MIT/Apache-2.0',
    'classifiers': [
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'License :: OSI Approved :: Apache Software License',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
    ],
    'install_requires': REQUIRES,
    'tests_require': ['coverage', 'pytest'],
    'packages': find_packages(),
    'entry_points': {
        'console_scripts': [
            'ryo-iso = ryo_iso.cli:cli',
        ],
    },

}

#################### BEGIN USER OVERRIDES ####################
# Add your customizations in this section.
kwargs['include_package_data']=True

###################### END USER OVERRIDES ####################

setup(**kwargs)
