"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodedeployCommandsSecure = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
 *
 * @experimental
 */
class CodedeployCommandsSecure extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [codedeploy-commands-secure](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscodedeploysecurehostcommandsservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'codedeploy-commands-secure';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Read: [
                'GetDeploymentSpecification',
                'PollHostCommand'
            ],
            Write: [
                'PutHostCommandAcknowledgement',
                'PutHostCommandComplete'
            ]
        };
    }
    /**
     * (experimental) Grants permission to get deployment specification.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toGetDeploymentSpecification() {
        return this.to('GetDeploymentSpecification');
    }
    /**
     * (experimental) Grants permission to request host agent commands.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPollHostCommand() {
        return this.to('PollHostCommand');
    }
    /**
     * (experimental) Grants permission to mark host agent commands acknowledged.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPutHostCommandAcknowledgement() {
        return this.to('PutHostCommandAcknowledgement');
    }
    /**
     * (experimental) Grants permission to mark host agent commands completed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/codedeploy/latest/userguide/vpc-endpoints.html#vpc-codedeploy-agent-configuration
     *
     * @experimental
     */
    toPutHostCommandComplete() {
        return this.to('PutHostCommandComplete');
    }
}
exports.CodedeployCommandsSecure = CodedeployCommandsSecure;
_a = JSII_RTTI_SYMBOL_1;
CodedeployCommandsSecure[_a] = { fqn: "iam-floyd.CodedeployCommandsSecure", version: "0.312.0" };
//# sourceMappingURL=data:application/json;base64,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