import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * (experimental) Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @experimental
 */
export declare class Controltower extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create an account managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toCreateManagedAccount(): this;
    /**
     * (experimental) Grants permission to deregister an account created through the account factory from AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDeregisterManagedAccount(): this;
    /**
     * (experimental) Grants permission to deregister an organizational unit from AWS Control Tower management.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toDeregisterOrganizationalUnit(): this;
    /**
     * (experimental) Grants permission to describe the current account factory configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDescribeAccountFactoryConfig(): this;
    /**
     * (experimental) Grants permission to describe resources managed by core accounts in AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     *
     * @experimental
     */
    toDescribeCoreService(): this;
    /**
     * (experimental) Grants permission to describe a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toDescribeGuardrail(): this;
    /**
     * (experimental) Grants permission to describe a guardrail for a organizational unit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toDescribeGuardrailForTarget(): this;
    /**
     * (experimental) Grants permission to describe an account created through account factory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDescribeManagedAccount(): this;
    /**
     * (experimental) Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toDescribeManagedOrganizationalUnit(): this;
    /**
     * (experimental) Grants permission to describe the current AWS Control Tower SSO configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     *
     * @experimental
     */
    toDescribeSingleSignOn(): this;
    /**
     * (experimental) Grants permission to disable a guardrail from an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     *
     * @experimental
     */
    toDisableGuardrail(): this;
    /**
     * (experimental) Grants permission to enable a guardrail to an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     *
     * @experimental
     */
    toEnableGuardrail(): this;
    /**
     * (experimental) Grants permission to list available updates for the current AWS Control Tower deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     *
     * @experimental
     */
    toGetAvailableUpdates(): this;
    /**
     * (experimental) Grants permission to get the current compliance status of a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toGetGuardrailComplianceStatus(): this;
    /**
     * (experimental) Grants permission to get the home region of the AWS Control Tower setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     *
     * @experimental
     */
    toGetHomeRegion(): this;
    /**
     * (experimental) Grants permission to get the current status of the landing zone setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     *
     * @experimental
     */
    toGetLandingZoneStatus(): this;
    /**
     * (experimental) Grants permission to list the current directory groups available through SSO.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     *
     * @experimental
     */
    toListDirectoryGroups(): this;
    /**
     * (experimental) Grants permission to list currently enabled guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListEnabledGuardrails(): this;
    /**
     * (experimental) Grants permission to list existing guardrail violations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrailViolations(): this;
    /**
     * (experimental) Grants permission to list all available guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrails(): this;
    /**
     * (experimental) Grants permission to list guardrails and their current state for a organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrailsForTarget(): this;
    /**
     * (experimental) Grants permission to list accounts managed through AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccounts(): this;
    /**
     * (experimental) Grants permission to list managed accounts with a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccountsForGuardrail(): this;
    /**
     * (experimental) Grants permission to list managed accounts under an organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccountsForParent(): this;
    /**
     * (experimental) Grants permission to list organizational units managed by AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toListManagedOrganizationalUnits(): this;
    /**
     * (experimental) Grants permission to list managed organizational units that have a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toListManagedOrganizationalUnitsForGuardrail(): this;
    /**
     * (experimental) Grants permission to set up an organizational unit to be managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toManageOrganizationalUnit(): this;
    /**
     * (experimental) Grants permission to set up or update AWS Control Tower landing zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     *
     * @experimental
     */
    toSetupLandingZone(): this;
    /**
     * (experimental) Grants permission to update the account factory configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toUpdateAccountFactoryConfig(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
}
