"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsSubscription = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
/**
 * Use an sms address as a subscription target.
 *
 * @stability stable
 */
class SmsSubscription {
    /**
     * @stability stable
     */
    constructor(phoneNumber, props = {}) {
        this.phoneNumber = phoneNumber;
        this.props = props;
    }
    /**
     * Returns a configuration used to subscribe to an SNS topic.
     *
     * @stability stable
     */
    bind(_topic) {
        return {
            subscriberId: this.phoneNumber,
            endpoint: this.phoneNumber,
            protocol: sns.SubscriptionProtocol.SMS,
            filterPolicy: this.props.filterPolicy,
        };
    }
}
exports.SmsSubscription = SmsSubscription;
_a = JSII_RTTI_SYMBOL_1;
SmsSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.SmsSubscription", version: "1.104.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic21zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic21zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDOzs7Ozs7QUFZeEMsTUFBYSxlQUFlOzs7O0lBQzFCLFlBQTZCLFdBQW1CLEVBQW1CLFFBQThCLEVBQUU7UUFBdEUsZ0JBQVcsR0FBWCxXQUFXLENBQVE7UUFBbUIsVUFBSyxHQUFMLEtBQUssQ0FBMkI7SUFDbkcsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE1BQWtCO1FBQzVCLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDOUIsUUFBUSxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzFCLFFBQVEsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsR0FBRztZQUN0QyxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZO1NBQ3RDLENBQUM7SUFDSixDQUFDOztBQVhILDBDQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc25zIGZyb20gJ0Bhd3MtY2RrL2F3cy1zbnMnO1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uUHJvcHMgfSBmcm9tICcuL3N1YnNjcmlwdGlvbic7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIFNtc1N1YnNjcmlwdGlvblByb3BzIGV4dGVuZHMgU3Vic2NyaXB0aW9uUHJvcHMge1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBTbXNTdWJzY3JpcHRpb24gaW1wbGVtZW50cyBzbnMuSVRvcGljU3Vic2NyaXB0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwaG9uZU51bWJlcjogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTbXNTdWJzY3JpcHRpb25Qcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfdG9waWM6IHNucy5JVG9waWMpOiBzbnMuVG9waWNTdWJzY3JpcHRpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzdWJzY3JpYmVySWQ6IHRoaXMucGhvbmVOdW1iZXIsXG4gICAgICBlbmRwb2ludDogdGhpcy5waG9uZU51bWJlcixcbiAgICAgIHByb3RvY29sOiBzbnMuU3Vic2NyaXB0aW9uUHJvdG9jb2wuU01TLFxuICAgICAgZmlsdGVyUG9saWN5OiB0aGlzLnByb3BzLmZpbHRlclBvbGljeSxcbiAgICB9O1xuICB9XG59XG4iXX0=