"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/salesforce/r/user salesforce_user}
*/
class User extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/salesforce/r/user salesforce_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'salesforce_user',
            terraformGeneratorMetadata: {
                providerName: 'salesforce',
                providerVersion: '0.1.0',
                providerVersionConstraint: '~> 0.1'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._alias = config.alias;
        this._email = config.email;
        this._emailEncodingKey = config.emailEncodingKey;
        this._languageLocaleKey = config.languageLocaleKey;
        this._lastName = config.lastName;
        this._localeSidKey = config.localeSidKey;
        this._profileId = config.profileId;
        this._resetPassword = config.resetPassword;
        this._timeZoneSidKey = config.timeZoneSidKey;
        this._userRoleId = config.userRoleId;
        this._username = config.username;
    }
    get alias() {
        return this.getStringAttribute('alias');
    }
    set alias(value) {
        this._alias = value;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get email() {
        return this.getStringAttribute('email');
    }
    set email(value) {
        this._email = value;
    }
    // Temporarily expose input value. Use with caution.
    get emailInput() {
        return this._email;
    }
    get emailEncodingKey() {
        return this.getStringAttribute('email_encoding_key');
    }
    set emailEncodingKey(value) {
        this._emailEncodingKey = value;
    }
    resetEmailEncodingKey() {
        this._emailEncodingKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emailEncodingKeyInput() {
        return this._emailEncodingKey;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get languageLocaleKey() {
        return this.getStringAttribute('language_locale_key');
    }
    set languageLocaleKey(value) {
        this._languageLocaleKey = value;
    }
    resetLanguageLocaleKey() {
        this._languageLocaleKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get languageLocaleKeyInput() {
        return this._languageLocaleKey;
    }
    get lastName() {
        return this.getStringAttribute('last_name');
    }
    set lastName(value) {
        this._lastName = value;
    }
    // Temporarily expose input value. Use with caution.
    get lastNameInput() {
        return this._lastName;
    }
    get localeSidKey() {
        return this.getStringAttribute('locale_sid_key');
    }
    set localeSidKey(value) {
        this._localeSidKey = value;
    }
    resetLocaleSidKey() {
        this._localeSidKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get localeSidKeyInput() {
        return this._localeSidKey;
    }
    get profileId() {
        return this.getStringAttribute('profile_id');
    }
    set profileId(value) {
        this._profileId = value;
    }
    // Temporarily expose input value. Use with caution.
    get profileIdInput() {
        return this._profileId;
    }
    get resetPassword() {
        return this.getBooleanAttribute('reset_password');
    }
    set resetPassword(value) {
        this._resetPassword = value;
    }
    resetResetPassword() {
        this._resetPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get resetPasswordInput() {
        return this._resetPassword;
    }
    get timeZoneSidKey() {
        return this.getStringAttribute('time_zone_sid_key');
    }
    set timeZoneSidKey(value) {
        this._timeZoneSidKey = value;
    }
    resetTimeZoneSidKey() {
        this._timeZoneSidKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeZoneSidKeyInput() {
        return this._timeZoneSidKey;
    }
    get userRoleId() {
        return this.getStringAttribute('user_role_id');
    }
    set userRoleId(value) {
        this._userRoleId = value;
    }
    resetUserRoleId() {
        this._userRoleId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userRoleIdInput() {
        return this._userRoleId;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alias: cdktf.stringToTerraform(this._alias),
            email: cdktf.stringToTerraform(this._email),
            email_encoding_key: cdktf.stringToTerraform(this._emailEncodingKey),
            language_locale_key: cdktf.stringToTerraform(this._languageLocaleKey),
            last_name: cdktf.stringToTerraform(this._lastName),
            locale_sid_key: cdktf.stringToTerraform(this._localeSidKey),
            profile_id: cdktf.stringToTerraform(this._profileId),
            reset_password: cdktf.booleanToTerraform(this._resetPassword),
            time_zone_sid_key: cdktf.stringToTerraform(this._timeZoneSidKey),
            user_role_id: cdktf.stringToTerraform(this._userRoleId),
            username: cdktf.stringToTerraform(this._username),
        };
    }
}
exports.User = User;
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@cdktf/provider-salesforce.user.User", version: "3.0.0" };
// =================
// STATIC PROPERTIES
// =================
User.tfResourceType = "salesforce_user";
//# sourceMappingURL=data:application/json;base64,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