"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunEcsFargateTask = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const run_ecs_task_base_1 = require("./run-ecs-task-base");
/**
 * Start a service on an ECS cluster
 *
 * @deprecated replaced by `EcsRunTask`
 */
class RunEcsFargateTask extends run_ecs_task_base_1.EcsRunTaskBase {
    constructor(props) {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTask", "replaced by `EcsRunTask`");
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_RunEcsFargateTaskProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, RunEcsFargateTask);
            }
            throw error;
        }
        if (!props.taskDefinition.isFargateCompatible) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with Fargate');
        }
        if (!props.taskDefinition.defaultContainer) {
            throw new Error('A TaskDefinition must have at least one essential container');
        }
        super({
            ...props,
            parameters: {
                LaunchType: 'FARGATE',
            },
        });
        this.configureAwsVpcNetworking(props.cluster.vpc, props.assignPublicIp, props.subnets, props.securityGroup);
    }
}
exports.RunEcsFargateTask = RunEcsFargateTask;
_a = JSII_RTTI_SYMBOL_1;
RunEcsFargateTask[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.RunEcsFargateTask", version: "1.165.0" };
//# sourceMappingURL=data:application/json;base64,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