"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send events to an EventBridge event bus
 */
class EventBridgePutEvents extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_tasks_EventBridgePutEventsProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgePutEvents);
            }
            throw error;
        }
        this.integrationPattern = props.integrationPattern ?? sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS);
        if (this.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.entries.map(entry => entry.detail))) {
                throw new Error('Task Token is required in `entries`. Use JsonPath.taskToken to set the token.');
            }
        }
        this.validateEntries();
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['events:PutEvents'],
                resources: this.eventBusArns,
            }),
        ];
    }
    /**
     * Returns an array of EventBusArn strings based on this.props.entries
     */
    get eventBusArns() {
        return this.props.entries
            .map(entry => {
            if (entry.eventBus) {
                // If an eventBus is provided, use the corresponding ARN
                return entry.eventBus.eventBusArn;
            }
            else {
                // If neither an eventBus nor eventBusName is provided,
                // format the ARN for the default event bus in the account.
                return cdk.Stack.of(this).formatArn({
                    resource: 'event-bus',
                    resourceName: 'default',
                    arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
                    service: 'events',
                });
            }
        });
    }
    /**
     * Provides the EventBridge put events service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('events', 'putEvents', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Entries: this.renderEntries(),
            }),
        };
    }
    renderEntries() {
        return this.props.entries.map(entry => {
            if (entry.source?.startsWith('aws')) {
                throw new Error('Event source cannot start with "aws."');
            }
            else {
                return {
                    Detail: entry.detail?.value,
                    DetailType: entry.detailType,
                    EventBusName: entry.eventBus?.eventBusArn,
                    Source: entry.source,
                };
            }
        });
    }
    validateEntries() {
        if (this.props.entries.length <= 0) {
            throw new Error('Value for property `entries` must be a non-empty array.');
        }
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EventBridgePutEvents", version: "1.165.0" };
EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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