from ..models import State, Chamber, District, simple_numbered_districts

AK = State(
    name="Alaska",
    abbr="AK",
    capital="Juneau",
    capital_tz="America/Anchorage",
    fips="02",
    unicameral=False,
    legislature_name="Alaska State Legislature",
    legislature_organization_id="ocd-organization/7971e631-d3d5-41e4-a83c-60ed2368e115",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/0aae43ba-c873-5720-a8eb-e4f03af9cc42",
    division_id="ocd-division/country:us/state:ak",
    jurisdiction_id="ocd-jurisdiction/country:us/state:ak/government",
    url="http://w3.legis.state.ak.us/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/9c84bc85-9bb0-4f31-99ad-5fed91afdc28",
        num_seats=40,
        title="Representative",
        districts=simple_numbered_districts(
            "ocd-division/country:us/state:ak", "lower", 40
        ),
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/85b8d5c1-0dde-4280-8528-9ef5d9fb5b5e",
        num_seats=20,
        title="Senator",
        districts=[
            District("A", "upper", "ocd-division/country:us/state:ak/sldu:a", 1),
            District("B", "upper", "ocd-division/country:us/state:ak/sldu:b", 1),
            District("C", "upper", "ocd-division/country:us/state:ak/sldu:c", 1),
            District("D", "upper", "ocd-division/country:us/state:ak/sldu:d", 1),
            District("E", "upper", "ocd-division/country:us/state:ak/sldu:e", 1),
            District("F", "upper", "ocd-division/country:us/state:ak/sldu:f", 1),
            District("G", "upper", "ocd-division/country:us/state:ak/sldu:g", 1),
            District("H", "upper", "ocd-division/country:us/state:ak/sldu:h", 1),
            District("I", "upper", "ocd-division/country:us/state:ak/sldu:i", 1),
            District("J", "upper", "ocd-division/country:us/state:ak/sldu:j", 1),
            District("K", "upper", "ocd-division/country:us/state:ak/sldu:k", 1),
            District("L", "upper", "ocd-division/country:us/state:ak/sldu:l", 1),
            District("M", "upper", "ocd-division/country:us/state:ak/sldu:m", 1),
            District("N", "upper", "ocd-division/country:us/state:ak/sldu:n", 1),
            District("O", "upper", "ocd-division/country:us/state:ak/sldu:o", 1),
            District("P", "upper", "ocd-division/country:us/state:ak/sldu:p", 1),
            District("Q", "upper", "ocd-division/country:us/state:ak/sldu:q", 1),
            District("R", "upper", "ocd-division/country:us/state:ak/sldu:r", 1),
            District("S", "upper", "ocd-division/country:us/state:ak/sldu:s", 1),
            District("T", "upper", "ocd-division/country:us/state:ak/sldu:t", 1),
        ],
    ),
)
