# Generated by Django 3.1.7 on 2021-06-29 11:24

from django.db import migrations


def process_tasks(apps, schema_editor):
    Task = apps.get_model('djautotask', 'Task')

    # Remove tasks without a project in preparation for migration
    # removing null=True from project foreign key on Task model.
    null_project_tasks = Task.objects.filter(project__isnull=True)
    for task in null_project_tasks:
        task.delete()


class Migration(migrations.Migration):

    dependencies = [
        ('djautotask', '0091_auto_20210525_1723'),
    ]

    operations = [
        migrations.RunPython(process_tasks)
    ]
