This is the Commandline client for Genskew_univiecube, which will automatically be installed when installing Genskew_univiecube.

GenSkew is an application for computing and plotting nucleotide skew data.

GenSkew calculates the incremental and the cumulative skew of two selectable nucleotides for a given sequence according to this formula:
Skew = (nucleotide1 - nucleotide2) / (nucleotide1 + nucleotide2)

The results are provided as data table and as graphical plot. The global minimum and maximum are displayed in the cumulative graph. The minimum and maximum of a GC-skew can be used to predict the origin of replication (minimum) and the terminus location (maximum) in prokaryotic genomes.

Installing the program with the command you can copy above will install the Genskew library as well as the Genskew commandline interface. By calling python3 -m genskew -h you will see a detailed description how to use the commandline interface. It can analyze multiple sequences in one command.

For using the library you first have to specify the aequence as an object: 

import genskew_univiecube as gs

sequence = "GATCCTAGATTAAGC"

name = gs.Object(sequence, "G", "C", stepsize, windowsize)

In this example the sequence is a string and the first nucleotide is G and the second is C. Stepssize and Windowsize don't have to be specified, if they are not specified they will be automatically calculated. This is usefull if multiple sequences are processed after another.

After the Object is defined, we need to generate the results:

import genskew_univiecube as gs


sequence = gs.gen_sequence(filelocation, "fasta")
name = gs.Object(sequence, "G", "C", stepsize, windowsize)
result = gs.Object.gen_results(name)

In this example the sequence is generated by calling gen_sequence, this takes a fasta or genbank file and outputs a string with the sequence in it.
The results can be retrieved as follows:

import genskew_univiecube as gs


sequence = gs.gen_sequence(filelocation, "fasta")
name = gs.Object(sequence, "G", "C", stepsize, windowsize)
result = gs.Object.gen_results(name)

print(result.skew)
gs.plot_sequence(result, filelocation, outputfolder, output_filetype, dpi)

There are different results: .skew (which will output the skew as a listof y values), .x (which will output the corresponding x values), .cumulative (which will output the cumulative skew as y values), .max_cm_position and .min_cm_position (outputs the x value of the max / min cumulative), .stepsize and .windowsize (outputs as integer), .nuc_1 and .nuc_2 (outputs the first and second nucleotide as a string)

plot_sequence plots and saves a graph of the skew. The arguments dpi, out_filetype and outputfolder are optional, the default output file type is png and the outputfolder is by default the folder in which the sequence file was (filelocation). The dpi is calculated according to the size of the graph.

Note, that in this example only one sequence can be analyzed at once.

