"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
const path = require("path");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @experimental
 */
class EvaluateExpression {
    constructor(props) {
        this.props = props;
    }
    bind(task) {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.Data.stringAt(m),
            }), {});
        }
        const evalFn = createEvalFn(this.props.runtime || lambda.Runtime.NODEJS_10_X, task);
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            resourceArn: evalFn.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: [evalFn.functionArn],
                    actions: ['lambda:InvokeFunction'],
                })],
            parameters,
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
function createEvalFn(runtime, scope) {
    const code = lambda.Code.asset(path.join(__dirname, `eval-${runtime.name}-handler`));
    const lambdaPurpose = 'Eval';
    switch (runtime) {
        case lambda.Runtime.NODEJS_10_X:
            return new lambda.SingletonFunction(scope, 'EvalFunction', {
                runtime,
                handler: 'index.handler',
                uuid: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
                lambdaPurpose,
                code,
            });
        // TODO: implement other runtimes
        default:
            throw new Error(`The runtime ${runtime.name} is currently not supported.`);
    }
}
//# sourceMappingURL=data:application/json;base64,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