"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
/**
 * A Step Functions Task to invoke a Lambda function.
 *
 * The Lambda function Arn is defined as Resource in the state machine definition.
 *
 * OUTPUT: the output of this task is the return value of the Lambda Function.
 *
 * @deprecated Use `LambdaInvoke`
 */
class InvokeFunction {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        this.props = props;
    }
    bind(_task) {
        return {
            resourceArn: this.lambdaFunction.functionArn,
            policyStatements: [new iam.PolicyStatement({
                    resources: [this.lambdaFunction.functionArn],
                    actions: ['lambda:InvokeFunction'],
                })],
            metricPrefixSingular: 'LambdaFunction',
            metricPrefixPlural: 'LambdaFunctions',
            metricDimensions: { LambdaFunctionArn: this.lambdaFunction.functionArn },
            parameters: this.props.payload,
        };
    }
}
exports.InvokeFunction = InvokeFunction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWZ1bmN0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW52b2tlLWZ1bmN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXdDO0FBb0J4Qzs7Ozs7Ozs7R0FRRztBQUNILE1BQWEsY0FBYztJQUN6QixZQUE2QixjQUFnQyxFQUFtQixRQUE2QixFQUFFO1FBQWxGLG1CQUFjLEdBQWQsY0FBYyxDQUFrQjtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUEwQjtJQUMvRyxDQUFDO0lBRU0sSUFBSSxDQUFDLEtBQWU7UUFDekIsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVc7WUFDNUMsZ0JBQWdCLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7b0JBQ3pDLFNBQVMsRUFBRSxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDO29CQUM1QyxPQUFPLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQztpQkFDbkMsQ0FBQyxDQUFDO1lBQ0gsb0JBQW9CLEVBQUUsZ0JBQWdCO1lBQ3RDLGtCQUFrQixFQUFFLGlCQUFpQjtZQUNyQyxnQkFBZ0IsRUFBRSxFQUFFLGlCQUFpQixFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxFQUFFO1lBQ3hFLFVBQVUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87U0FDL0IsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQWpCRCx3Q0FpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzZm4gZnJvbSAnQGF3cy1jZGsvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEludm9rZUZ1bmN0aW9uXG4gKlxuICogQGRlcHJlY2F0ZWQgdXNlIGBMYW1iZGFJbnZva2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW52b2tlRnVuY3Rpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgSlNPTiB0aGF0IHlvdSB3YW50IHRvIHByb3ZpZGUgdG8geW91ciBMYW1iZGEgZnVuY3Rpb24gYXMgaW5wdXQuXG4gICAqXG4gICAqIFRoaXMgcGFyYW1ldGVyIGlzIG5hbWVkIGFzIHBheWxvYWQgdG8ga2VlcCBjb25zaXN0ZW50IHdpdGggUnVuTGFtYmRhVGFzayBjbGFzcy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBUaGUgSlNPTiBkYXRhIGluZGljYXRlZCBieSB0aGUgdGFzaydzIElucHV0UGF0aCBpcyB1c2VkIGFzIHBheWxvYWRcbiAgICovXG4gIHJlYWRvbmx5IHBheWxvYWQ/OiB7IFtrZXk6IHN0cmluZ106IGFueSB9O1xufVxuXG4vKipcbiAqIEEgU3RlcCBGdW5jdGlvbnMgVGFzayB0byBpbnZva2UgYSBMYW1iZGEgZnVuY3Rpb24uXG4gKlxuICogVGhlIExhbWJkYSBmdW5jdGlvbiBBcm4gaXMgZGVmaW5lZCBhcyBSZXNvdXJjZSBpbiB0aGUgc3RhdGUgbWFjaGluZSBkZWZpbml0aW9uLlxuICpcbiAqIE9VVFBVVDogdGhlIG91dHB1dCBvZiB0aGlzIHRhc2sgaXMgdGhlIHJldHVybiB2YWx1ZSBvZiB0aGUgTGFtYmRhIEZ1bmN0aW9uLlxuICpcbiAqIEBkZXByZWNhdGVkIFVzZSBgTGFtYmRhSW52b2tlYFxuICovXG5leHBvcnQgY2xhc3MgSW52b2tlRnVuY3Rpb24gaW1wbGVtZW50cyBzZm4uSVN0ZXBGdW5jdGlvbnNUYXNrIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBsYW1iZGFGdW5jdGlvbjogbGFtYmRhLklGdW5jdGlvbiwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogSW52b2tlRnVuY3Rpb25Qcm9wcyA9IHt9KSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfdGFzazogc2ZuLlRhc2spOiBzZm4uU3RlcEZ1bmN0aW9uc1Rhc2tDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICByZXNvdXJjZUFybjogdGhpcy5sYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybixcbiAgICAgIHBvbGljeVN0YXRlbWVudHM6IFtuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIHJlc291cmNlczogW3RoaXMubGFtYmRhRnVuY3Rpb24uZnVuY3Rpb25Bcm5dLFxuICAgICAgICBhY3Rpb25zOiBbJ2xhbWJkYTpJbnZva2VGdW5jdGlvbiddLFxuICAgICAgfSldLFxuICAgICAgbWV0cmljUHJlZml4U2luZ3VsYXI6ICdMYW1iZGFGdW5jdGlvbicsXG4gICAgICBtZXRyaWNQcmVmaXhQbHVyYWw6ICdMYW1iZGFGdW5jdGlvbnMnLFxuICAgICAgbWV0cmljRGltZW5zaW9uczogeyBMYW1iZGFGdW5jdGlvbkFybjogdGhpcy5sYW1iZGFGdW5jdGlvbi5mdW5jdGlvbkFybiB9LFxuICAgICAgcGFyYW1ldGVyczogdGhpcy5wcm9wcy5wYXlsb2FkLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==