"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const sfn = require("@aws-cdk/aws-stepfunctions");
const core_1 = require("@aws-cdk/core");
const tasks = require("../lib");
let stack;
beforeEach(() => {
    stack = new core_1.Stack();
});
test('Eval with Node.js', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '$.a + $.b',
        }),
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    // THEN
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Parameters":{"expression":"$.a + $.b","expressionAttributeValues":{"$.a.$":"$.a","$.b.$":"$.b"}},"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': [
                            'Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1',
                            'Arn',
                        ],
                    },
                    '"}}}',
                ],
            ],
        },
    });
    expect(stack).toHaveResource('AWS::Lambda::Function', {
        Runtime: 'nodejs10.x',
    });
});
test('expression does not contain paths', () => {
    // WHEN
    const task = new sfn.Task(stack, 'Task', {
        task: new tasks.EvaluateExpression({
            expression: '2 + 2',
        }),
    });
    new sfn.StateMachine(stack, 'SM', {
        definition: task,
    });
    expect(stack).toHaveResource('AWS::StepFunctions::StateMachine', {
        DefinitionString: {
            'Fn::Join': [
                '',
                [
                    '{"StartAt":"Task","States":{"Task":{"End":true,"Parameters":{"expression":"2 + 2",\"expressionAttributeValues\":{}},"Type":"Task","Resource":"',
                    {
                        'Fn::GetAtt': [
                            'Evala0d2ce44871b4e7487a1f5e63d7c3bdc4DAC06E1',
                            'Arn',
                        ],
                    },
                    '"}}}',
                ],
            ],
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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