"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeStarConnectionsSourceAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * A CodePipeline source action for the CodeStar Connections source, which allows connecting to GitHub and BitBucket.
 *
 * @stability stable
 */
class CodeStarConnectionsSourceAction extends action_1.Action {
    /**
     * @stability stable
     */
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            owner: 'AWS',
            provider: 'CodeStarSourceConnection',
            artifactBounds: common_1.sourceArtifactBounds(),
            outputs: [props.output],
        });
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    bound(_scope, _stage, options) {
        var _b;
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/security-iam.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'codestar-connections:UseConnection',
            ],
            resources: [
                this.props.connectionArn,
            ],
        }));
        // the action needs to write the output to the pipeline bucket
        options.bucket.grantReadWrite(options.role);
        options.bucket.grantPutAcl(options.role);
        // if codeBuildCloneOutput is true,
        // save the connectionArn in the Artifact instance
        // to be read by the CodeBuildAction later
        if (this.props.codeBuildCloneOutput === true) {
            this.props.output.setMetadata(CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY, this.props.connectionArn);
        }
        return {
            configuration: {
                ConnectionArn: this.props.connectionArn,
                FullRepositoryId: `${this.props.owner}/${this.props.repo}`,
                BranchName: (_b = this.props.branch) !== null && _b !== void 0 ? _b : 'master',
                OutputArtifactFormat: this.props.codeBuildCloneOutput === true
                    ? 'CODEBUILD_CLONE_REF'
                    : undefined,
                DetectChanges: this.props.triggerOnPush,
            },
        };
    }
}
exports.CodeStarConnectionsSourceAction = CodeStarConnectionsSourceAction;
_a = JSII_RTTI_SYMBOL_1;
CodeStarConnectionsSourceAction[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.CodeStarConnectionsSourceAction", version: "1.110.0" };
/**
 * The name of the property that holds the ARN of the CodeStar Connection
 * inside of the CodePipeline Artifact's metadata.
 *
 * @internal
 */
CodeStarConnectionsSourceAction._CONNECTION_ARN_PROPERTY = 'CodeStarConnectionArnProperty';
//# sourceMappingURL=data:application/json;base64,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