import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * A unique id for the deployment config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#config_id GameServicesGameServerConfig#config_id}
     *
     * @stability stable
     */
    readonly configId: string;
    /**
     * A unique id for the deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#deployment_id GameServicesGameServerConfig#deployment_id}
     *
     * @stability stable
     */
    readonly deploymentId: string;
    /**
     * The description of the game server config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#description GameServicesGameServerConfig#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The labels associated with this game server config. Each label is a key-value pair.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#labels GameServicesGameServerConfig#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Location of the Deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#location GameServicesGameServerConfig#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#project GameServicesGameServerConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * fleet_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_configs GameServicesGameServerConfig#fleet_configs}
     *
     * @stability stable
     */
    readonly fleetConfigs: GameServicesGameServerConfigFleetConfigs[];
    /**
     * scaling_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#scaling_configs GameServicesGameServerConfig#scaling_configs}
     *
     * @stability stable
     */
    readonly scalingConfigs?: GameServicesGameServerConfigScalingConfigs[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#timeouts GameServicesGameServerConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: GameServicesGameServerConfigTimeouts;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigFleetConfigs {
    /**
     * The fleet spec, which is sent to Agones to configure fleet.
     *
     * The spec can be passed as inline json but it is recommended to use a file reference
     * instead. File references can contain the json or yaml format of the fleet spec. Eg:
     *
     * fleet_spec = jsonencode(yamldecode(file("fleet_configs.yaml")))
     * fleet_spec = file("fleet_configs.json")
     *
     * The format of the spec can be found :
     * 'https://agones.dev/site/docs/reference/fleet/'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_spec GameServicesGameServerConfig#fleet_spec}
     *
     * @stability stable
     */
    readonly fleetSpec: string;
    /**
     * The name of the FleetConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#name GameServicesGameServerConfig#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigScalingConfigsSchedules {
    /**
     * The duration for the cron job event. The duration of the event is effective after the cron job's start time.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#cron_job_duration GameServicesGameServerConfig#cron_job_duration}
     *
     * @stability stable
     */
    readonly cronJobDuration?: string;
    /**
     * The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#cron_spec GameServicesGameServerConfig#cron_spec}
     *
     * @stability stable
     */
    readonly cronSpec?: string;
    /**
     * The end time of the event.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#end_time GameServicesGameServerConfig#end_time}
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * The start time of the event.
     *
     * A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#start_time GameServicesGameServerConfig#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigScalingConfigsSelectors {
    /**
     * Set of labels to group by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#labels GameServicesGameServerConfig#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigScalingConfigs {
    /**
     * Fleet autoscaler spec, which is sent to Agones. Example spec can be found : https://agones.dev/site/docs/reference/fleetautoscaler/.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#fleet_autoscaler_spec GameServicesGameServerConfig#fleet_autoscaler_spec}
     *
     * @stability stable
     */
    readonly fleetAutoscalerSpec: string;
    /**
     * The name of the ScalingConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#name GameServicesGameServerConfig#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * schedules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#schedules GameServicesGameServerConfig#schedules}
     *
     * @stability stable
     */
    readonly schedules?: GameServicesGameServerConfigScalingConfigsSchedules[];
    /**
     * selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#selectors GameServicesGameServerConfig#selectors}
     *
     * @stability stable
     */
    readonly selectors?: GameServicesGameServerConfigScalingConfigsSelectors[];
}
/**
 * @stability stable
 */
export interface GameServicesGameServerConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#create GameServicesGameServerConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html#delete GameServicesGameServerConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class GameServicesGameServerConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html google_game_services_game_server_config}.
 *
 * @stability stable
 */
export declare class GameServicesGameServerConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config.html google_game_services_game_server_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GameServicesGameServerConfigConfig);
    private _configId?;
    /**
     * @stability stable
     */
    get configId(): string;
    /**
     * @stability stable
     */
    set configId(value: string);
    /**
     * @stability stable
     */
    get configIdInput(): string | undefined;
    private _deploymentId?;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    /**
     * @stability stable
     */
    set deploymentId(value: string);
    /**
     * @stability stable
     */
    get deploymentIdInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _fleetConfigs?;
    /**
     * @stability stable
     */
    get fleetConfigs(): GameServicesGameServerConfigFleetConfigs[];
    /**
     * @stability stable
     */
    set fleetConfigs(value: GameServicesGameServerConfigFleetConfigs[]);
    /**
     * @stability stable
     */
    get fleetConfigsInput(): GameServicesGameServerConfigFleetConfigs[] | undefined;
    private _scalingConfigs?;
    /**
     * @stability stable
     */
    get scalingConfigs(): GameServicesGameServerConfigScalingConfigs[] | undefined;
    /**
     * @stability stable
     */
    set scalingConfigs(value: GameServicesGameServerConfigScalingConfigs[] | undefined);
    /**
     * @stability stable
     */
    resetScalingConfigs(): void;
    /**
     * @stability stable
     */
    get scalingConfigsInput(): GameServicesGameServerConfigScalingConfigs[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): GameServicesGameServerConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: GameServicesGameServerConfigTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): GameServicesGameServerConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
