import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#bucket StorageObjectAcl#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#object StorageObjectAcl#object}.
     *
     * @stability stable
     */
    readonly object: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#predefined_acl StorageObjectAcl#predefined_acl}.
     *
     * @stability stable
     */
    readonly predefinedAcl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html#role_entity StorageObjectAcl#role_entity}.
     *
     * @stability stable
     */
    readonly roleEntity?: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html google_storage_object_acl}.
 *
 * @stability stable
 */
export declare class StorageObjectAcl extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl.html google_storage_object_acl} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageObjectAclConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
    private _predefinedAcl?;
    /**
     * @stability stable
     */
    get predefinedAcl(): string | undefined;
    /**
     * @stability stable
     */
    set predefinedAcl(value: string | undefined);
    /**
     * @stability stable
     */
    resetPredefinedAcl(): void;
    /**
     * @stability stable
     */
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    /**
     * @stability stable
     */
    get roleEntity(): string[] | undefined;
    /**
     * @stability stable
     */
    set roleEntity(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRoleEntity(): void;
    /**
     * @stability stable
     */
    get roleEntityInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
