# mypy-boto3-cloudwatch<a id="mypy-boto3-cloudwatch"></a>

[![PyPI - mypy-boto3-cloudwatch](https://img.shields.io/pypi/v/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-cloudwatch?color=blue)](https://pypistats.org/packages/mypy-boto3-cloudwatch)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CloudWatch 1.17.88](https://boto3.amazonaws.com/v1/documentation/api/1.17.88/reference/services/cloudwatch.html#CloudWatch)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-cloudwatch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudwatch/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-cloudwatch](#mypy-boto3-cloudwatch)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `CloudWatch` service.

```bash
python -m pip install boto3-stubs[cloudwatch]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[cloudwatch]` in your environment:
  `python -m pip install 'boto3-stubs[cloudwatch]'`

Both type checking and auto-complete should work for `CloudWatch` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[cloudwatch]` in your environment:
  `python -m pip install 'boto3-stubs[cloudwatch]'`

Both type checking and auto-complete should work for `CloudWatch` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[cloudwatch]` in your environment:
  `python -m pip install 'boto3-stubs[cloudwatch]'`
- Run `mypy` as usual

Type checking should work for `CloudWatch` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[cloudwatch]` in your environment:
  `python -m pip install 'boto3-stubs[cloudwatch]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CloudWatch` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`CloudWatchClient` provides annotations for `boto3.client("cloudwatch")`.

```python
import boto3

from mypy_boto3_cloudwatch import CloudWatchClient

client: CloudWatchClient = boto3.client("cloudwatch")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudWatchClient = session.client("cloudwatch")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_cloudwatch.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_cloudwatch import CloudWatchClient
from mypy_boto3_cloudwatch.paginator import (
    DescribeAlarmHistoryPaginator,
    DescribeAlarmsPaginator,
    GetMetricDataPaginator,
    ListDashboardsPaginator,
    ListMetricsPaginator,
)

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_alarm_history_paginator: DescribeAlarmHistoryPaginator = client.get_paginator("describe_alarm_history")
describe_alarms_paginator: DescribeAlarmsPaginator = client.get_paginator("describe_alarms")
get_metric_data_paginator: GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_dashboards_paginator: ListDashboardsPaginator = client.get_paginator("list_dashboards")
list_metrics_paginator: ListMetricsPaginator = client.get_paginator("list_metrics")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_cloudwatch.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_cloudwatch import CloudWatchClient
from mypy_boto3_cloudwatch.waiter import (
    AlarmExistsWaiter,
    CompositeAlarmExistsWaiter,
)

client: CloudWatchClient = boto3.client("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
alarm_exists_waiter: AlarmExistsWaiter = client.get_waiter("alarm_exists")
composite_alarm_exists_waiter: CompositeAlarmExistsWaiter = client.get_waiter("composite_alarm_exists")
```

### Service Resource annotations<a id="service-resource-annotations"></a>

`CloudWatchServiceResource` provides annotations for
`boto3.resource("cloudwatch")`.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: CloudWatchServiceResource = session.resource("cloudwatch")
```

### Other resources annotations<a id="other-resources-annotations"></a>

`mypy_boto3_cloudwatch.service_resource` module contains type annotations for
all resources.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource
from mypy_boto3_cloudwatch.service_resource import (
    Alarm,
    Metric,
)

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_alarm: Alarm = resource.Alarm(...)
my_metric: Metric = resource.Metric(...)
```

### Collections annotations<a id="collections-annotations"></a>

`mypy_boto3_cloudwatch.service_resource` module contains type annotations for
all `CloudWatchServiceResource` collections.

```python
from mypy_boto3_cloudwatch import CloudWatchServiceResource
from mypy_boto3_cloudwatch.service_resource import (
    ServiceResourceAlarmsCollection,
    ServiceResourceMetricsCollection,
)

resource: CloudWatchServiceResource = boto3.resource("cloudwatch")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
alarms: cloudwatch_resources.ServiceResourceAlarmsCollection = resource.alarms
metrics: cloudwatch_resources.ServiceResourceMetricsCollection = resource.metrics
```

### Literals<a id="literals"></a>

`mypy_boto3_cloudwatch.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_cloudwatch.literals import (
    AlarmExistsWaiterName,
    AlarmTypeType,
    AnomalyDetectorStateValueType,
    ComparisonOperatorType,
    CompositeAlarmExistsWaiterName,
    DescribeAlarmHistoryPaginatorName,
    DescribeAlarmsPaginatorName,
    GetMetricDataPaginatorName,
    HistoryItemTypeType,
    ListDashboardsPaginatorName,
    ListMetricsPaginatorName,
    MetricStreamOutputFormatType,
    RecentlyActiveType,
    ScanByType,
    StandardUnitType,
    StateValueType,
    StatisticType,
    StatusCodeType,
)

def check_value(value: AlarmExistsWaiterName) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_cloudwatch.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_cloudwatch.type_defs import (
    AlarmHistoryItemTypeDef,
    AnomalyDetectorConfigurationTypeDef,
    AnomalyDetectorTypeDef,
    CompositeAlarmTypeDef,
    DashboardEntryTypeDef,
    DashboardValidationMessageTypeDef,
    DatapointTypeDef,
    DeleteInsightRulesOutputTypeDef,
    DescribeAlarmHistoryOutputTypeDef,
    DescribeAlarmsForMetricOutputTypeDef,
    DescribeAlarmsOutputTypeDef,
    DescribeAnomalyDetectorsOutputTypeDef,
    DescribeInsightRulesOutputTypeDef,
    DimensionFilterTypeDef,
    DimensionTypeDef,
    DisableInsightRulesOutputTypeDef,
    EnableInsightRulesOutputTypeDef,
    GetDashboardOutputTypeDef,
    GetInsightRuleReportOutputTypeDef,
    GetMetricDataOutputTypeDef,
    GetMetricStatisticsOutputTypeDef,
    GetMetricStreamOutputTypeDef,
    GetMetricWidgetImageOutputTypeDef,
    InsightRuleContributorDatapointTypeDef,
    InsightRuleContributorTypeDef,
    InsightRuleMetricDatapointTypeDef,
    InsightRuleTypeDef,
    LabelOptionsTypeDef,
    ListDashboardsOutputTypeDef,
    ListMetricStreamsOutputTypeDef,
    ListMetricsOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    MessageDataTypeDef,
    MetricAlarmTypeDef,
    MetricDataQueryTypeDef,
    MetricDataResultTypeDef,
    MetricDatumTypeDef,
    MetricStatTypeDef,
    MetricStreamEntryTypeDef,
    MetricStreamFilterTypeDef,
    MetricTypeDef,
    PaginatorConfigTypeDef,
    PartialFailureTypeDef,
    PutDashboardOutputTypeDef,
    PutMetricStreamOutputTypeDef,
    RangeTypeDef,
    ResponseMetadataTypeDef,
    StatisticSetTypeDef,
    TagTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AlarmHistoryItemTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-cloudwatch` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-cloudwatch docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_cloudwatch/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
