import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-cdk.aws-sns",
    "version": "0.26.0",
    "description": "CDK Constructs for AWS SNS",
    "url": "https://github.com/awslabs/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/awslabs/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_sns",
        "aws_cdk.aws_sns._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_sns._jsii": [
            "aws-sns@0.26.0.jsii.tgz"
        ],
        "aws_cdk.aws_sns": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii",
        "publication>=0.0.3",
        "aws-cdk.aws-autoscaling-api~=0.26.0",
        "aws-cdk.aws-cloudwatch~=0.26.0",
        "aws-cdk.aws-events~=0.26.0",
        "aws-cdk.aws-iam~=0.26.0",
        "aws-cdk.aws-lambda~=0.26.0",
        "aws-cdk.aws-s3-notifications~=0.26.0",
        "aws-cdk.aws-sqs~=0.26.0",
        "aws-cdk.cdk~=0.26.0"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
