import { PolicyDocument } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/cdk';
import { ITopic } from './topic-base';
export interface TopicPolicyProps {
    /**
     * The set of topics this policy applies to.
     */
    readonly topics: ITopic[];
}
/**
 * Applies a policy to SNS topics.
 */
export declare class TopicPolicy extends Construct {
    /**
     * The IAM policy document for this policy.
     */
    readonly document: PolicyDocument;
    constructor(scope: Construct, id: string, props: TopicPolicyProps);
}
