"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk_1 = require("@aws-cdk/cdk");
const sns_generated_1 = require("./sns.generated");
/**
 * Applies a policy to SNS topics.
 */
class TopicPolicy extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        new sns_generated_1.CfnTopicPolicy(this, 'Resource', {
            policyDocument: this.document,
            topics: props.topics.map(t => t.topicArn)
        });
    }
}
exports.TopicPolicy = TopicPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQWtEO0FBQ2xELHNDQUF5QztBQUN6QyxtREFBaUQ7QUFVakQ7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxlQUFTO0lBTXhDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQU5uQjs7V0FFRztRQUNhLGFBQVEsR0FBRyxJQUFJLHdCQUFjLEVBQUUsQ0FBQztRQUs5QyxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDN0IsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztTQUMxQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFkRCxrQ0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBvbGljeURvY3VtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jZGsnO1xuaW1wb3J0IHsgQ2ZuVG9waWNQb2xpY3kgfSBmcm9tICcuL3Nucy5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgSVRvcGljIH0gZnJvbSAnLi90b3BpYy1iYXNlJztcblxuZXhwb3J0IGludGVyZmFjZSBUb3BpY1BvbGljeVByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBzZXQgb2YgdG9waWNzIHRoaXMgcG9saWN5IGFwcGxpZXMgdG8uXG4gICAqL1xuICByZWFkb25seSB0b3BpY3M6IElUb3BpY1tdO1xufVxuXG4vKipcbiAqIEFwcGxpZXMgYSBwb2xpY3kgdG8gU05TIHRvcGljcy5cbiAqL1xuZXhwb3J0IGNsYXNzIFRvcGljUG9saWN5IGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgLyoqXG4gICAqIFRoZSBJQU0gcG9saWN5IGRvY3VtZW50IGZvciB0aGlzIHBvbGljeS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBkb2N1bWVudCA9IG5ldyBQb2xpY3lEb2N1bWVudCgpO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUb3BpY1BvbGljeVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIG5ldyBDZm5Ub3BpY1BvbGljeSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBwb2xpY3lEb2N1bWVudDogdGhpcy5kb2N1bWVudCxcbiAgICAgIHRvcGljczogcHJvcHMudG9waWNzLm1hcCh0ID0+IHQudG9waWNBcm4pXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==