"use strict";
// Copyright 2012-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable:max-line-length | This is generated code - line lengths are difficult to control
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const topic_base_1 = require("./topic-base");
topic_base_1.TopicBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric(Object.assign({ namespace: 'AWS/SNS', metricName, dimensions: { TopicName: this.topicName } }, props));
};
topic_base_1.TopicBase.prototype.metricPublishSize = function (props) {
    return this.metric('PublishSize', Object.assign({ statistic: 'Average' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfMessagesPublished = function (props) {
    return this.metric('NumberOfMessagesPublished', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsDelivered = function (props) {
    return this.metric('NumberOfNotificationsDelivered', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFailed = function (props) {
    return this.metric('NumberOfNotificationsFailed', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOut = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutNoMessageAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-NoMessageAttributes', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutInvalidAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-InvalidAttributes', Object.assign({ statistic: 'Sum' }, props));
};
topic_base_1.TopicBase.prototype.metricSMSMonthToDateSpentUSD = function (props) {
    return this.metric('SMSMonthToDateSpentUSD', Object.assign({ statistic: 'Maximum' }, props));
};
topic_base_1.TopicBase.prototype.metricSMSSuccessRate = function (props) {
    return this.metric('SMSSuccessRate', Object.assign({ statistic: 'Sum' }, props));
};
//# sourceMappingURL=data:application/json;base64,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