"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const sns_generated_1 = require("./sns.generated");
/**
 * A new subscription.
 *
 * Prefer to use the `ITopic.subscribeXxx()` methods to creating instances of
 * this class.
 */
class Subscription extends cdk_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.rawMessageDelivery && ['http', 'https', 'sqs'].indexOf(props.protocol) < 0) {
            throw new Error('Raw message delivery can only be enabled for HTTP/S and SQS subscriptions.');
        }
        new sns_generated_1.CfnSubscription(this, 'Resource', {
            endpoint: props.endpoint,
            protocol: props.protocol,
            topicArn: props.topic.topicArn,
            rawMessageDelivery: props.rawMessageDelivery,
        });
    }
}
exports.Subscription = Subscription;
/**
 * The type of subscription, controlling the type of the endpoint parameter.
 */
var SubscriptionProtocol;
(function (SubscriptionProtocol) {
    /**
     * JSON-encoded message is POSTED to an HTTP url.
     */
    SubscriptionProtocol["Http"] = "http";
    /**
     * JSON-encoded message is POSTed to an HTTPS url.
     */
    SubscriptionProtocol["Https"] = "https";
    /**
     * Notifications are sent via email.
     */
    SubscriptionProtocol["Email"] = "email";
    /**
     * Notifications are JSON-encoded and sent via mail.
     */
    SubscriptionProtocol["EmailJson"] = "email-json";
    /**
     * Notification is delivered by SMS
     */
    SubscriptionProtocol["Sms"] = "sms";
    /**
     * Notifications are enqueued into an SQS queue.
     */
    SubscriptionProtocol["Sqs"] = "sqs";
    /**
     * JSON-encoded notifications are sent to a mobile app endpoint.
     */
    SubscriptionProtocol["Application"] = "application";
    /**
     * Notifications trigger a Lambda function.
     */
    SubscriptionProtocol["Lambda"] = "lambda";
})(SubscriptionProtocol = exports.SubscriptionProtocol || (exports.SubscriptionProtocol = {}));
//# sourceMappingURL=data:application/json;base64,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