import { Construct } from '@aws-cdk/cdk';
import { ITopic, TopicBase, TopicImportProps } from './topic-base';
/**
 * Properties for a new SNS topic
 */
export interface TopicProps {
    /**
     * A developer-defined string that can be used to identify this SNS topic.
     *
     * @default None
     */
    readonly displayName?: string;
    /**
     * A name for the topic.
     *
     * If you don't specify a name, AWS CloudFormation generates a unique
     * physical ID and uses that ID for the topic name. For more information,
     * see Name Type.
     *
     * @default Generated name
     */
    readonly topicName?: string;
}
/**
 * A new SNS topic
 */
export declare class Topic extends TopicBase {
    /**
     * Import a Topic defined elsewhere
     */
    static import(scope: Construct, id: string, props: TopicImportProps): ITopic;
    readonly topicArn: string;
    readonly topicName: string;
    protected readonly autoCreatePolicy: boolean;
    constructor(scope: Construct, id: string, props?: TopicProps);
    /**
     * Export this Topic
     */
    export(): TopicImportProps;
}
