"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk_1 = require("@aws-cdk/cdk");
const sns_generated_1 = require("./sns.generated");
const topic_base_1 = require("./topic-base");
/**
 * A new SNS topic
 */
class Topic extends topic_base_1.TopicBase {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.autoCreatePolicy = true;
        const resource = new sns_generated_1.CfnTopic(this, 'Resource', {
            displayName: props.displayName,
            topicName: props.topicName
        });
        this.topicArn = resource.ref;
        this.topicName = resource.topicName;
    }
    /**
     * Import a Topic defined elsewhere
     */
    static import(scope, id, props) {
        return new ImportedTopic(scope, id, props);
    }
    /**
     * Export this Topic
     */
    export() {
        return {
            topicArn: new cdk_1.CfnOutput(this, 'TopicArn', { value: this.topicArn }).makeImportValue().toString(),
            topicName: new cdk_1.CfnOutput(this, 'TopicName', { value: this.topicName }).makeImportValue().toString(),
        };
    }
}
exports.Topic = Topic;
/**
 * An imported topic
 */
class ImportedTopic extends topic_base_1.TopicBase {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.autoCreatePolicy = false;
        this.topicArn = props.topicArn;
        this.topicName = props.topicName;
    }
    export() {
        return this.props;
    }
}
//# sourceMappingURL=data:application/json;base64,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