"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/cdk");
const sns = require("../lib");
class MyStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const objectCreateTopic = new sns.Topic(this, 'ObjectCreatedTopic');
        const objectRemovedTopic = new sns.Topic(this, 'ObjectDeletedTopic');
        const bucket = new s3.Bucket(this, 'MyBucket', {
            removalPolicy: cdk.RemovalPolicy.Destroy
        });
        bucket.onObjectCreated(objectCreateTopic);
        bucket.onObjectRemoved(objectRemovedTopic, { prefix: 'foo/', suffix: '.txt' });
    }
}
const app = new cdk.App();
new MyStack(app, 'sns-bucket-notifications');
app.run();
//# sourceMappingURL=data:application/json;base64,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