"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events = require("@aws-cdk/aws-events");
const sqs = require("@aws-cdk/aws-sqs");
const cdk = require("@aws-cdk/cdk");
const sns = require("../lib");
// ---------------------------------
// Define a rule that triggers an SNS topic every 1min.
// Connect the topic with a queue. This means that the queue should have
// a message sent to it every minute.
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-sns-event-target');
const topic = new sns.Topic(stack, 'MyTopic');
const event = new events.EventRule(stack, 'EveryMinute', {
    scheduleExpression: 'rate(1 minute)'
});
const queue = new sqs.Queue(stack, 'MyQueue');
topic.subscribeQueue(queue);
event.addTarget(topic);
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc25zLWV2ZW50LXJ1bGUtdGFyZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc25zLWV2ZW50LXJ1bGUtdGFyZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQStDO0FBQy9DLHdDQUF5QztBQUN6QyxvQ0FBcUM7QUFDckMsOEJBQStCO0FBRS9CLG9DQUFvQztBQUNwQyx1REFBdUQ7QUFDdkQsd0VBQXdFO0FBQ3hFLHFDQUFxQztBQUVyQyxNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDBCQUEwQixDQUFDLENBQUM7QUFFN0QsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztBQUM5QyxNQUFNLEtBQUssR0FBRyxJQUFJLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtJQUN2RCxrQkFBa0IsRUFBRSxnQkFBZ0I7Q0FDckMsQ0FBQyxDQUFDO0FBRUgsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztBQUM5QyxLQUFLLENBQUMsY0FBYyxDQUFDLEtBQUssQ0FBQyxDQUFDO0FBRTVCLEtBQUssQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUM7QUFFdkIsR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGV2ZW50cyA9IHJlcXVpcmUoJ0Bhd3MtY2RrL2F3cy1ldmVudHMnKTtcbmltcG9ydCBzcXMgPSByZXF1aXJlKCdAYXdzLWNkay9hd3Mtc3FzJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgc25zID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbi8vIC0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuLy8gRGVmaW5lIGEgcnVsZSB0aGF0IHRyaWdnZXJzIGFuIFNOUyB0b3BpYyBldmVyeSAxbWluLlxuLy8gQ29ubmVjdCB0aGUgdG9waWMgd2l0aCBhIHF1ZXVlLiBUaGlzIG1lYW5zIHRoYXQgdGhlIHF1ZXVlIHNob3VsZCBoYXZlXG4vLyBhIG1lc3NhZ2Ugc2VudCB0byBpdCBldmVyeSBtaW51dGUuXG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLXNucy1ldmVudC10YXJnZXQnKTtcblxuY29uc3QgdG9waWMgPSBuZXcgc25zLlRvcGljKHN0YWNrLCAnTXlUb3BpYycpO1xuY29uc3QgZXZlbnQgPSBuZXcgZXZlbnRzLkV2ZW50UnVsZShzdGFjaywgJ0V2ZXJ5TWludXRlJywge1xuICBzY2hlZHVsZUV4cHJlc3Npb246ICdyYXRlKDEgbWludXRlKSdcbn0pO1xuXG5jb25zdCBxdWV1ZSA9IG5ldyBzcXMuUXVldWUoc3RhY2ssICdNeVF1ZXVlJyk7XG50b3BpYy5zdWJzY3JpYmVRdWV1ZShxdWV1ZSk7XG5cbmV2ZW50LmFkZFRhcmdldCh0b3BpYyk7XG5cbmFwcC5ydW4oKTtcbiJdfQ==