"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.addBaseTags = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const env = require("./env");
function addBaseTags(module, props) {
    aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.ENVIRONMENT, env.ENVIRONMENT);
    aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.TIMESTAMP_DEPLOY_CDK, env.TIMESTAMP_DEPLOY_CDK);
    let businessUnit = props?.businessUnit ?? env.BUSINESS_UNIT;
    if (businessUnit) {
        aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.BUSINESS_UNIT, businessUnit);
    }
    let domain = props?.domain ?? env.DOMAIN;
    if (domain) {
        aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.DOMAIN, domain);
    }
    let repositoryName = props?.repositoryName ?? env.REPOSITORY_NAME;
    if (repositoryName) {
        aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.REPOSITORY_NAME, repositoryName);
    }
    let repositoryVersion = props?.repositoryVersion ?? env.REPOSITORY_VERSION;
    if (repositoryVersion) {
        aws_cdk_lib_1.Tags.of(module).add(env.TagsKey.REPOSITORY_VERSION, repositoryVersion);
    }
}
exports.addBaseTags = addBaseTags;
//# sourceMappingURL=data:application/json;base64,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