"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a SQS queue as a Lambda destination.
 *
 * @stability stable
 */
class SqsDestination {
    /**
     * @stability stable
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope, fn, _options) {
        // deduplicated automatically
        this.queue.grantSendMessages(fn);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDestination = SqsDestination;
_a = JSII_RTTI_SYMBOL_1;
SqsDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.SqsDestination", version: "1.110.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7QUFLQSxNQUFhLGNBQWM7Ozs7SUFDekIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtJQUM5QyxDQUFDOzs7Ozs7SUFHTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxFQUFvQixFQUFFLFFBQW9DO1FBQ3ZGLDZCQUE2QjtRQUM3QixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBRWpDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7SUFDSixDQUFDOztBQVpILHdDQWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3FzRGVzdGluYXRpb24gaW1wbGVtZW50cyBsYW1iZGEuSURlc3RpbmF0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIGZuOiBsYW1iZGEuSUZ1bmN0aW9uLCBfb3B0aW9ucz86IGxhbWJkYS5EZXN0aW5hdGlvbk9wdGlvbnMpOiBsYW1iZGEuRGVzdGluYXRpb25Db25maWcge1xuICAgIC8vIGRlZHVwbGljYXRlZCBhdXRvbWF0aWNhbGx5XG4gICAgdGhpcy5xdWV1ZS5ncmFudFNlbmRNZXNzYWdlcyhmbik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMucXVldWUucXVldWVBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19