# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
from datetime import datetime

# Add ParMOO's modules to path
sys.path.insert(0, os.path.abspath('.'))
sys.path.insert(0, os.path.abspath('..'))
sys.path.insert(0, os.path.abspath('../parmoo'))


# -- Project information -----------------------------------------------------

project = 'ParMOO'
copyright = str(datetime.now().year) + ' Tyler Chang, Stefan Wild'
author = 'Tyler Chang and Stefan Wild'

# The full version, including alpha/beta/rc tags
exec(open("../parmoo/version.py").read())
version = __version__
release = version


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc', 'sphinx.ext.napoleon']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'python3'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# Stefan needed this
# see https://github.com/rtfd/readthedocs.org/issues/2569
master_doc = 'index'

# The latex toctree document
latex_doc = 'latex_index'

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'
html_theme_options = {'navigation_depth': 3,
                      'logo_only': True}
html_logo = './img/logo-ParMOO_white.png'

# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    'fncychap': "\\usepackage[Lenny]{fncychap}",
    'extraclassoptions': "openany",
    'preamble': r"""
    \protected\def\sphinxcrossref#1{\texttt{#1}}

    \newsavebox\mytempbox
    \definecolor{sphinxnoteBgColor}{RGB}{221,233,239}
    \renewenvironment{sphinxnote}[1]{%
    \begin{lrbox}{\mytempbox}%
    \begin{minipage}{\columnwidth}%
    \begin{sphinxlightbox}%
    \sphinxstrong{#1}}%
    {\end{sphinxlightbox}%
    \end{minipage}%
    \end{lrbox}%
    \colorbox{sphinxnoteBgColor}{\usebox{\mytempbox}}}
    """,
    }

latex_documents = [
    (latex_doc, "parmoo.tex", "ParMOO User's Manual",
     "Tyler Chang and Stefan Wild", "manual"),
     ]

latex_logo = "img/logo-ParMOO_white.png"


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []
