#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Mar 28 12:06:04 2022

@author: jtm545
"""

import numpy as np
import pandas as pd


def CIE2006_LMS_CMFs(age=32.0, field_size=2.0):

    # Check input params
    bad_input = False
    if age < 20:
        age, bad_input = 20, True
    if age > 80:
        age, bad_input = 80, True
    if field_size < 1:
        field_size, bad_input = 1, True
    if field_size > 10:
        field_size, bad_input = 10, True
    if bad_input:
        print(
            f"Params out of range, adjusted to age={age}, field_size={field_size}"
        )

    # Get the raw data. Note that the first two points of each have been
    # interpolated.
    A_lms = get_A_lms()
    d = get_CIEOP06_optical_density()
    rmd = get_CIEOP06_macula_density().squeeze()

    # Field size corrected macular density
    corrected_rmd = rmd * (0.485 * np.exp(-field_size / 6.132))

    # Age corrected lens/ocular media density
    if age <= 60.0:
        correct_lomd = d["D1"].mul(1 + (0.02 * (age - 32))) + d["D2"]
    else:
        correct_lomd = d["D1"].mul(1.56 + (0.0667 * (age - 60))) + d["D2"]

    # Corrected LMS (no age correction)
    alpha_LMS = 0.0 * A_lms
    alpha_LMS["Al"] = 1 - 10 ** (
        -(0.38 + 0.54 * np.exp(-field_size / 1.333)) * (10 ** A_lms["Al"])
    )
    alpha_LMS["Am"] = 1 - 10 ** (
        -(0.38 + 0.54 * np.exp(-field_size / 1.333)) * (10 ** A_lms["Am"])
    )
    alpha_LMS["As"] = 1 - 10 ** (
        -(0.3 + 0.45 * np.exp(-field_size / 1.333)) * (10 ** A_lms["As"])
    )
    alpha_LMS = alpha_LMS.replace(np.nan, 0)

    # Corrected to Corneal Incidence
    lms_barq = alpha_LMS.mul((10 ** (-corrected_rmd - correct_lomd)), axis=0)

    # Corrected to Energy Terms
    lms_bar = lms_barq.mul(lms_barq.index, axis=0)

    # Normalized
    lms_bar_norm = lms_bar.div(lms_bar.max())

    return lms_bar_norm


def get_CIEOP06_optical_density():

    colnames = ["Wavelength", "D1", "D2"]

    densities = np.array(
        [
            390,
            0.809599,
            1.633701,
            395,
            0.735718,
            1.368382,
            400,
            0.661837,
            1.103063,
            405,
            0.587956,
            0.837744,
            410,
            0.530708,
            0.606672,
            415,
            0.46804,
            0.43826,
            420,
            0.427672,
            0.296308,
            425,
            0.393583,
            0.202137,
            430,
            0.372871,
            0.114729,
            435,
            0.336814,
            0.071286,
            440,
            0.310032,
            0.031288,
            445,
            0.282708,
            0.017272,
            450,
            0.258499,
            0.004381,
            455,
            0.24165,
            0.00215,
            460,
            0.2279,
            0,
            465,
            0.21306,
            0,
            470,
            0.20458,
            0,
            475,
            0.19292,
            0,
            480,
            0.18338,
            0,
            485,
            0.1749,
            0,
            490,
            0.16748,
            0,
            495,
            0.16006,
            0,
            500,
            0.1537,
            0,
            505,
            0.14628,
            0,
            510,
            0.1378,
            0,
            515,
            0.12932,
            0,
            520,
            0.12296,
            0,
            525,
            0.1166,
            0,
            530,
            0.11024,
            0,
            535,
            0.10494,
            0,
            540,
            0.09858,
            0,
            545,
            0.09222,
            0,
            550,
            0.08586,
            0,
            555,
            0.0795,
            0,
            560,
            0.0742,
            0,
            565,
            0.06784,
            0,
            570,
            0.06148,
            0,
            575,
            0.05512,
            0,
            580,
            0.04876,
            0,
            585,
            0.04346,
            0,
            590,
            0.03812,
            0,
            595,
            0.03286,
            0,
            600,
            0.02968,
            0,
            605,
            0.02544,
            0,
            610,
            0.02226,
            0,
            615,
            0.01908,
            0,
            620,
            0.01696,
            0,
            625,
            0.01484,
            0,
            630,
            0.01166,
            0,
            635,
            0.00848,
            0,
            640,
            0.0053,
            0,
            645,
            0.00424,
            0,
            650,
            0.00318,
            0,
            655,
            0.00106,
            0,
            660,
            0,
            0,
            665,
            0,
            0,
            670,
            0,
            0,
            675,
            0,
            0,
            680,
            0,
            0,
            685,
            0,
            0,
            690,
            0,
            0,
            695,
            0,
            0,
            700,
            0,
            0,
            705,
            0,
            0,
            710,
            0,
            0,
            715,
            0,
            0,
            720,
            0,
            0,
            725,
            0,
            0,
            730,
            0,
            0,
            735,
            0,
            0,
            740,
            0,
            0,
            745,
            0,
            0,
            750,
            0,
            0,
            755,
            0,
            0,
            760,
            0,
            0,
            765,
            0,
            0,
            770,
            0,
            0,
            775,
            0,
            0,
            780,
            0,
            0,
        ]
    )
    densities = densities.reshape(79, 3).astype(np.float64).T
    # densities = densities[:, ::binwidth]
    densities = pd.DataFrame(data=densities.T, columns=colnames)
    densities.set_index("Wavelength", inplace=True)
    densities.index = pd.Int64Index(densities.index)

    return densities


def get_CIEOP06_macula_density():

    colnames = ["Wavelength", "D"]

    d = np.array(
        [
            390,
            0.1295,
            395,
            0.1854,
            400,
            0.2480,
            405,
            0.3200,
            410,
            0.3900,
            415,
            0.4660,
            420,
            0.5660,
            425,
            0.6700,
            430,
            0.7480,
            435,
            0.7920,
            440,
            0.8240,
            445,
            0.8800,
            450,
            0.9520,
            455,
            0.9960,
            460,
            1.0000,
            465,
            0.9340,
            470,
            0.8560,
            475,
            0.8120,
            480,
            0.7960,
            485,
            0.7920,
            490,
            0.7680,
            495,
            0.7100,
            500,
            0.5980,
            505,
            0.4720,
            510,
            0.3460,
            515,
            0.2320,
            520,
            0.1500,
            525,
            0.0940,
            530,
            0.0500,
            535,
            0.0265,
            540,
            0.0131,
            545,
            0.0047,
            550,
            0.0000,
            555,
            0.0000,
            560,
            0.0000,
            565,
            0.0000,
            570,
            0.0000,
            575,
            0.0000,
            580,
            0.0000,
            585,
            0.0000,
            590,
            0.0000,
            595,
            0.0000,
            600,
            0.0000,
            605,
            0.0000,
            610,
            0.0000,
            615,
            0.0000,
            620,
            0.0000,
            625,
            0.0000,
            630,
            0.0000,
            635,
            0.0000,
            640,
            0.0000,
            645,
            0.0000,
            650,
            0.0000,
            655,
            0.0000,
            660,
            0.0000,
            665,
            0.0000,
            670,
            0.0000,
            675,
            0.0000,
            680,
            0.0000,
            685,
            0.0000,
            690,
            0.0000,
            695,
            0.0000,
            700,
            0.0000,
            705,
            0.0000,
            710,
            0.0000,
            715,
            0.0000,
            720,
            0.0000,
            725,
            0.0000,
            730,
            0.0000,
            735,
            0.0000,
            740,
            0.0000,
            745,
            0.0000,
            750,
            0.0000,
            755,
            0.0000,
            760,
            0.0000,
            765,
            0.0000,
            770,
            0.0000,
            775,
            0.0000,
            780,
            0.0000,
        ]
    )

    d = d.reshape(79, 2).astype(np.float64).T
    d = pd.DataFrame(data=d.T, columns=colnames)
    d.set_index("Wavelength", inplace=True)
    d.index = pd.Int64Index(d.index)
    return d

    d = d.reshape(79, 2).astype(np.float64).T
    d = pd.DataFrame(data=d.T, columns=colnames)
    d.set_index("Wavelength", inplace=True)
    d.index = pd.Int64Index(d.index)
    return d.squeeze()


def get_A_lms():

    colnames = ["Wavelength", "Al", "Am", "As"]
    a = np.array(
        [
            390,
            -0.93379,
            -1.0479,
            -0.13385,
            395,
            -0.89477,
            -0.99737,
            -0.09075,
            400,
            -0.88346,
            -0.97071,
            -0.0499,
            405,
            -0.90163,
            -0.97422,
            -0.02576,
            410,
            -0.91541,
            -0.97112,
            -0.00926,
            415,
            -0.94085,
            -0.9623,
            -0.00238,
            420,
            -0.95489,
            -0.93984,
            -3e-05,
            425,
            -0.95756,
            -0.89896,
            -0.00547,
            430,
            -0.95359,
            -0.85645,
            -0.02225,
            435,
            -0.93902,
            -0.80274,
            -0.05,
            440,
            -0.92675,
            -0.76267,
            -0.08115,
            445,
            -0.90407,
            -0.71587,
            -0.12009,
            450,
            -0.87342,
            -0.66754,
            -0.1667,
            455,
            -0.8335,
            -0.61743,
            -0.23983,
            460,
            -0.78013,
            -0.55431,
            -0.31463,
            465,
            -0.72114,
            -0.49235,
            -0.40119,
            470,
            -0.66428,
            -0.43737,
            -0.51694,
            475,
            -0.61223,
            -0.39247,
            -0.66272,
            480,
            -0.55146,
            -0.34047,
            -0.81657,
            485,
            -0.48714,
            -0.28496,
            -0.96832,
            490,
            -0.42894,
            -0.23781,
            -1.13208,
            495,
            -0.36178,
            -0.18206,
            -1.28916,
            500,
            -0.30399,
            -0.13844,
            -1.45859,
            505,
            -0.2499,
            -0.09801,
            -1.65743,
            510,
            -0.20069,
            -0.06439,
            -1.88089,
            515,
            -0.15585,
            -0.03834,
            -2.08698,
            520,
            -0.10935,
            -0.00948,
            -2.29299,
            525,
            -0.07711,
            0.0,
            -2.50132,
            530,
            -0.05499,
            -0.00367,
            -2.71463,
            535,
            -0.0332,
            -0.00825,
            -2.92459,
            540,
            -0.00946,
            -0.01459,
            -3.14134,
            545,
            0.0,
            -0.03704,
            -3.36041,
            550,
            -0.00396,
            -0.07306,
            -3.58132,
            555,
            -0.00144,
            -0.10546,
            -3.80348,
            560,
            -0.00553,
            -0.14855,
            -4.02353,
            565,
            -0.01383,
            -0.1966,
            -4.24415,
            570,
            -0.028,
            -0.25538,
            -4.46335,
            575,
            -0.05189,
            -0.32506,
            -4.68031,
            580,
            -0.08632,
            -0.40844,
            -4.89433,
            585,
            -0.11133,
            -0.49035,
            -5.10375,
            590,
            -0.146,
            -0.5788,
            -5.30914,
            595,
            -0.18983,
            -0.67909,
            -5.50995,
            600,
            -0.23784,
            -0.78679,
            -5.70383,
            605,
            -0.29291,
            -0.90539,
            -5.89362,
            610,
            -0.35607,
            -1.03047,
            -6.07699,
            615,
            -0.42682,
            -1.16171,
            -6.25482,
            620,
            -0.50264,
            -1.29891,
            np.nan,
            625,
            -0.58334,
            -1.44247,
            np.nan,
            630,
            -0.68087,
            -1.59094,
            np.nan,
            635,
            -0.78537,
            -1.74439,
            np.nan,
            640,
            -0.89178,
            -1.90327,
            np.nan,
            645,
            -0.99863,
            -2.06748,
            np.nan,
            650,
            -1.12017,
            -2.22219,
            np.nan,
            655,
            -1.25234,
            -2.38712,
            np.nan,
            660,
            -1.38794,
            -2.55821,
            np.nan,
            665,
            -1.52676,
            -2.72867,
            np.nan,
            670,
            -1.67004,
            -2.89245,
            np.nan,
            675,
            -1.81845,
            -3.05604,
            np.nan,
            680,
            -1.97248,
            -3.22105,
            np.nan,
            685,
            -2.13249,
            -3.3887,
            np.nan,
            690,
            -2.29941,
            -3.5602,
            np.nan,
            695,
            -2.46026,
            -3.72423,
            np.nan,
            700,
            -2.62094,
            -3.88522,
            np.nan,
            705,
            -2.78302,
            -4.04716,
            np.nan,
            710,
            -2.95024,
            -4.21252,
            np.nan,
            715,
            -3.11779,
            -4.37575,
            np.nan,
            720,
            -3.28148,
            -4.53499,
            np.nan,
            725,
            -3.44462,
            -4.69279,
            np.nan,
            730,
            -3.60461,
            -4.847,
            np.nan,
            735,
            -3.76398,
            -5.00024,
            np.nan,
            740,
            -3.92373,
            -5.1522,
            np.nan,
            745,
            -4.07815,
            -5.29757,
            np.nan,
            750,
            -4.23309,
            -5.44366,
            np.nan,
            755,
            -4.3856,
            -5.58742,
            np.nan,
            760,
            -4.53587,
            -5.72846,
            np.nan,
            765,
            -4.68548,
            -5.86949,
            np.nan,
            770,
            -4.8323,
            -6.00833,
            np.nan,
            775,
            -4.97979,
            -6.14754,
            np.nan,
            780,
            -5.12256,
            -6.28158,
            np.nan,
        ]
    )
    a = a.reshape(79, 4).astype(np.float64).T
    a = pd.DataFrame(data=a.T, columns=colnames)
    a.set_index("Wavelength", inplace=True)
    a.index = pd.Int64Index(a.index)
    return a
