#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
pysilsub.precep
===============

Convenience functions for accessing prereceptoral filter functions.

Obtained from http://www.cvrl.org/

@author: jtm

"""

from typing import Optional, Union

import numpy as np
import pandas as pd


def get_lens_density_spectra(
    binwidth: Optional[int] = 1,
    asdf: Optional[bool] = True,
    trim_visible: Optional[bool] = False,
) -> Union[np.ndarray, pd.DataFrame]:
    """Get lens density spectra.

    See the following refs for further information:

    Stiles, W. S., & Burch, J. M. (1959). NPL colour-matching investigation:
        Final report (1958). Optica Acta, 6, 1-26.

    Stockman, A., Sharpe, L. T., & Fach, C. C. (1999). The spectral sensitivity
        of the human short-wavelength cones. Vision Research, 39, 2901-2927.

    Stockman, A., & Sharpe, L. T. (2000). Spectral sensitivities of the middle-
        and long-wavelength sensitive cones derived from measurements in
        observers of known genotype. Vision Research, 40, 1711-1737.

    van Norren, D. & Vos J.J. (1974) Spectral transmission of the human ocular
        media Vision Research, 14, 1237-1244.

    Parameters
    ----------
    asdf : bool, optional
        Whether to return the results as a pandas DataFrame. The default is
        True.
    binwidth : int, optional
        Width of the wavelength bins in nanometers (must be `1` or `5`). The
        default is `1`.
    trim_visible : bool, optional
        Whether to trim the CMFs to 380-780 nm. The default is True.

    Returns
    -------
    density : numpy.ndarray or pandas.DataFrame
        Lens optical density as a function of wavelength.

    """
    colnames = ["Wavelength", "Density"]

    density = np.array(
        [
            390,
            2.5122,
            391,
            2.4349,
            392,
            2.35804,
            393,
            2.28167,
            394,
            2.20584,
            395,
            2.1306,
            396,
            2.05599,
            397,
            1.98207,
            398,
            1.90889,
            399,
            1.83648,
            400,
            1.7649,
            401,
            1.69424,
            402,
            1.62472,
            403,
            1.55661,
            404,
            1.49018,
            405,
            1.4257,
            406,
            1.3634,
            407,
            1.30336,
            408,
            1.24564,
            409,
            1.1903,
            410,
            1.13738,
            411,
            1.08691,
            412,
            1.03874,
            413,
            0.9927,
            414,
            0.94861,
            415,
            0.9063,
            416,
            0.86566,
            417,
            0.82686,
            418,
            0.79015,
            419,
            0.75577,
            420,
            0.72398,
            421,
            0.69488,
            422,
            0.66805,
            423,
            0.64295,
            424,
            0.61902,
            425,
            0.59572,
            426,
            0.57263,
            427,
            0.54995,
            428,
            0.528,
            429,
            0.5071,
            430,
            0.4876,
            431,
            0.4697,
            432,
            0.45316,
            433,
            0.43762,
            434,
            0.42272,
            435,
            0.4081,
            436,
            0.39351,
            437,
            0.37919,
            438,
            0.36549,
            439,
            0.35275,
            440,
            0.34132,
            441,
            0.33143,
            442,
            0.32278,
            443,
            0.31493,
            444,
            0.30748,
            445,
            0.29998,
            446,
            0.29214,
            447,
            0.28417,
            448,
            0.27641,
            449,
            0.2692,
            450,
            0.26288,
            451,
            0.25768,
            452,
            0.25344,
            453,
            0.24989,
            454,
            0.24677,
            455,
            0.2438,
            456,
            0.24077,
            457,
            0.23765,
            458,
            0.23446,
            459,
            0.2312,
            460,
            0.2279,
            461,
            0.22458,
            462,
            0.22134,
            463,
            0.21827,
            464,
            0.21547,
            465,
            0.21306,
            466,
            0.21108,
            467,
            0.20941,
            468,
            0.20789,
            469,
            0.20633,
            470,
            0.20458,
            471,
            0.20251,
            472,
            0.20019,
            473,
            0.19774,
            474,
            0.19528,
            475,
            0.19292,
            476,
            0.19075,
            477,
            0.18876,
            478,
            0.1869,
            479,
            0.18512,
            480,
            0.18338,
            481,
            0.18164,
            482,
            0.1799,
            483,
            0.17818,
            484,
            0.17651,
            485,
            0.1749,
            486,
            0.17336,
            487,
            0.17187,
            488,
            0.17041,
            489,
            0.16895,
            490,
            0.16748,
            491,
            0.16597,
            492,
            0.16445,
            493,
            0.16294,
            494,
            0.16147,
            495,
            0.16006,
            496,
            0.15874,
            497,
            0.15747,
            498,
            0.15624,
            499,
            0.15499,
            500,
            0.1537,
            501,
            0.15234,
            502,
            0.15091,
            503,
            0.14942,
            504,
            0.14787,
            505,
            0.14628,
            506,
            0.14465,
            507,
            0.14298,
            508,
            0.14129,
            509,
            0.13956,
            510,
            0.1378,
            511,
            0.13602,
            512,
            0.13425,
            513,
            0.13252,
            514,
            0.13087,
            515,
            0.12932,
            516,
            0.1279,
            517,
            0.12659,
            518,
            0.12536,
            519,
            0.12416,
            520,
            0.12296,
            521,
            0.12174,
            522,
            0.12049,
            523,
            0.11921,
            524,
            0.11791,
            525,
            0.1166,
            526,
            0.11527,
            527,
            0.11395,
            528,
            0.11266,
            529,
            0.11142,
            530,
            0.11024,
            531,
            0.10915,
            532,
            0.1081,
            533,
            0.10708,
            534,
            0.10604,
            535,
            0.10494,
            536,
            0.10376,
            537,
            0.10251,
            538,
            0.10122,
            539,
            0.0999,
            540,
            0.09858,
            541,
            0.09728,
            542,
            0.096,
            543,
            0.09473,
            544,
            0.09347,
            545,
            0.09222,
            546,
            0.09097,
            547,
            0.08971,
            548,
            0.08844,
            549,
            0.08716,
            550,
            0.08586,
            551,
            0.08454,
            552,
            0.08322,
            553,
            0.08193,
            554,
            0.08068,
            555,
            0.0795,
            556,
            0.0784,
            557,
            0.07736,
            558,
            0.07634,
            559,
            0.0753,
            560,
            0.0742,
            561,
            0.07302,
            562,
            0.07177,
            563,
            0.07048,
            564,
            0.06916,
            565,
            0.06784,
            566,
            0.06654,
            567,
            0.06526,
            568,
            0.06399,
            569,
            0.06274,
            570,
            0.06148,
            571,
            0.06022,
            572,
            0.05896,
            573,
            0.05769,
            574,
            0.05641,
            575,
            0.05512,
            576,
            0.05381,
            577,
            0.0525,
            578,
            0.05121,
            579,
            0.04996,
            580,
            0.04876,
            581,
            0.04762,
            582,
            0.04654,
            583,
            0.0455,
            584,
            0.04448,
            585,
            0.04346,
            586,
            0.04243,
            587,
            0.04139,
            588,
            0.04032,
            589,
            0.03924,
            590,
            0.03812,
            591,
            0.03697,
            592,
            0.03584,
            593,
            0.03474,
            594,
            0.03374,
            595,
            0.03286,
            596,
            0.03213,
            597,
            0.03151,
            598,
            0.03093,
            599,
            0.03034,
            600,
            0.02968,
            601,
            0.0289,
            602,
            0.02804,
            603,
            0.02715,
            604,
            0.02626,
            605,
            0.02544,
            606,
            0.02471,
            607,
            0.02406,
            608,
            0.02345,
            609,
            0.02286,
            610,
            0.02226,
            611,
            0.02162,
            612,
            0.02096,
            613,
            0.0203,
            614,
            0.01966,
            615,
            0.01908,
            616,
            0.01857,
            617,
            0.01811,
            618,
            0.0177,
            619,
            0.01733,
            620,
            0.01696,
            621,
            0.01659,
            622,
            0.01621,
            623,
            0.0158,
            624,
            0.01535,
            625,
            0.01484,
            626,
            0.01427,
            627,
            0.01364,
            628,
            0.01299,
            629,
            0.01232,
            630,
            0.01166,
            631,
            0.01102,
            632,
            0.0104,
            633,
            0.00978,
            634,
            0.00914,
            635,
            0.00848,
            636,
            0.00778,
            637,
            0.00708,
            638,
            0.0064,
            639,
            0.0058,
            640,
            0.0053,
            641,
            0.00493,
            642,
            0.00467,
            643,
            0.00449,
            644,
            0.00436,
            645,
            0.00424,
            646,
            0.00411,
            647,
            0.00395,
            648,
            0.00375,
            649,
            0.0035,
            650,
            0.00318,
            651,
            0.00279,
            652,
            0.00236,
            653,
            0.0019,
            654,
            0.00146,
            655,
            0.00106,
            656,
            0.00072,
            657,
            0.00045,
            658,
            0.00025,
            659,
            0.0001,
            660,
            0,
            661,
            0,
            662,
            0,
            663,
            0,
            664,
            0,
            665,
            0,
            666,
            0,
            667,
            0,
            668,
            0,
            669,
            0,
            670,
            0,
            671,
            0,
            672,
            0,
            673,
            0,
            674,
            0,
            675,
            0,
            676,
            0,
            677,
            0,
            678,
            0,
            679,
            0,
            680,
            0,
            681,
            0,
            682,
            0,
            683,
            0,
            684,
            0,
            685,
            0,
            686,
            0,
            687,
            0,
            688,
            0,
            689,
            0,
            690,
            0,
            691,
            0,
            692,
            0,
            693,
            0,
            694,
            0,
            695,
            0,
            696,
            0,
            697,
            0,
            698,
            0,
            699,
            0,
            700,
            0,
            701,
            0,
            702,
            0,
            703,
            0,
            704,
            0,
            705,
            0,
            706,
            0,
            707,
            0,
            708,
            0,
            709,
            0,
            710,
            0,
            711,
            0,
            712,
            0,
            713,
            0,
            714,
            0,
            715,
            0,
            716,
            0,
            717,
            0,
            718,
            0,
            719,
            0,
            720,
            0,
            721,
            0,
            722,
            0,
            723,
            0,
            724,
            0,
            725,
            0,
            726,
            0,
            727,
            0,
            728,
            0,
            729,
            0,
            730,
            0,
            731,
            0,
            732,
            0,
            733,
            0,
            734,
            0,
            735,
            0,
            736,
            0,
            737,
            0,
            738,
            0,
            739,
            0,
            740,
            0,
            741,
            0,
            742,
            0,
            743,
            0,
            744,
            0,
            745,
            0,
            746,
            0,
            747,
            0,
            748,
            0,
            749,
            0,
            750,
            0,
            751,
            0,
            752,
            0,
            753,
            0,
            754,
            0,
            755,
            0,
            756,
            0,
            757,
            0,
            758,
            0,
            759,
            0,
            760,
            0,
            761,
            0,
            762,
            0,
            763,
            0,
            764,
            0,
            765,
            0,
            766,
            0,
            767,
            0,
            768,
            0,
            769,
            0,
            770,
            0,
            771,
            0,
            772,
            0,
            773,
            0,
            774,
            0,
            775,
            0,
            776,
            0,
            777,
            0,
            778,
            0,
            779,
            0,
            780,
            0,
            781,
            0,
            782,
            0,
            783,
            0,
            784,
            0,
            785,
            0,
            786,
            0,
            787,
            0,
            788,
            0,
            789,
            0,
            790,
            0,
            791,
            0,
            792,
            0,
            793,
            0,
            794,
            0,
            795,
            0,
            796,
            0,
            797,
            0,
            798,
            0,
            799,
            0,
            800,
            0,
            801,
            0,
            802,
            0,
            803,
            0,
            804,
            0,
            805,
            0,
            806,
            0,
            807,
            0,
            808,
            0,
            809,
            0,
            810,
            0,
            811,
            0,
            812,
            0,
            813,
            0,
            814,
            0,
            815,
            0,
            816,
            0,
            817,
            0,
            818,
            0,
            819,
            0,
            820,
            0,
            821,
            0,
            822,
            0,
            823,
            0,
            824,
            0,
            825,
            0,
            826,
            0,
            827,
            0,
            828,
            0,
            829,
            0,
            830,
            0,
        ]
    )
    density = density.reshape(441, 2).astype(np.float64).T
    if trim_visible:
        prepend = np.array([[wl, np.nan] for wl in range(380, 390)])
        density = np.vstack((prepend, density.T))
        density = density[density[:, 0] < 781].T
    density = density[:, ::binwidth]
    if asdf:
        density = pd.Series(density[1], index=density[0], name=colnames[1])
        density.index.name = colnames[0]
    return density


def get_macula_pigment_density_spectra(
    binwidth: Optional[int] = 1,
    asdf: Optional[bool] = True,
    trim_visible: Optional[bool] = False,
) -> Union[np.ndarray, pd.DataFrame]:
    """Get macula pigment density spectra.

    See the following refs for further information:

    Bone, R. A., Landrum, J. T., & Cains, A. (1992). Optical density spectra of
        the macular pigment in vivo and in vitro. Vision Research, 32, 105-110.

    Stockman, A., Sharpe, L. T., & Fach, C. C. (1999). The spectral sensitivity
        of the human short-wavelength cones. Vision Research, 39, 2901-2927.

    Parameters
    ----------
    asdf : bool, optional
        Whether to return the results as a pandas DataFrame. The default is
        False.
    binwidth : int, optional
        Width of the wavelength bins in nanometers (must be `1` or `5`). The
        default is `1`.
    trim_visible : bool, optional
        Whether to trim the CMFs to 380-780 nm. The default is True.

    Returns
    -------
    density : numpy.ndarray or pandas.DataFrame
        Macula pigment optical density as a function of wavelength.

    """
    colnames = ["Wavelength", "Density"]

    density = np.array(
        [
            390,
            0.04533,
            391,
            0.04918,
            392,
            0.05304,
            393,
            0.05693,
            394,
            0.06087,
            395,
            0.06489,
            396,
            0.069,
            397,
            0.07322,
            398,
            0.07758,
            399,
            0.0821,
            400,
            0.0868,
            401,
            0.09168,
            402,
            0.0967,
            403,
            0.1018,
            404,
            0.10692,
            405,
            0.112,
            406,
            0.11699,
            407,
            0.12192,
            408,
            0.12679,
            409,
            0.13164,
            410,
            0.1365,
            411,
            0.1414,
            412,
            0.14642,
            413,
            0.15165,
            414,
            0.15718,
            415,
            0.1631,
            416,
            0.16947,
            417,
            0.17624,
            418,
            0.18332,
            419,
            0.19063,
            420,
            0.1981,
            421,
            0.20564,
            422,
            0.21314,
            423,
            0.22052,
            424,
            0.22767,
            425,
            0.2345,
            426,
            0.24091,
            427,
            0.24687,
            428,
            0.25236,
            429,
            0.25734,
            430,
            0.2618,
            431,
            0.26573,
            432,
            0.26916,
            433,
            0.27218,
            434,
            0.27484,
            435,
            0.2772,
            436,
            0.27934,
            437,
            0.28139,
            438,
            0.28349,
            439,
            0.28578,
            440,
            0.2884,
            441,
            0.29146,
            442,
            0.29497,
            443,
            0.29892,
            444,
            0.30326,
            445,
            0.308,
            446,
            0.31307,
            447,
            0.31832,
            448,
            0.32355,
            449,
            0.32858,
            450,
            0.3332,
            451,
            0.33727,
            452,
            0.3408,
            453,
            0.34383,
            454,
            0.34641,
            455,
            0.3486,
            456,
            0.35039,
            457,
            0.35163,
            458,
            0.35211,
            459,
            0.35164,
            460,
            0.35,
            461,
            0.34707,
            462,
            0.34304,
            463,
            0.33816,
            464,
            0.3327,
            465,
            0.3269,
            466,
            0.32101,
            467,
            0.3152,
            468,
            0.30959,
            469,
            0.30435,
            470,
            0.2996,
            471,
            0.29546,
            472,
            0.29191,
            473,
            0.28888,
            474,
            0.28633,
            475,
            0.2842,
            476,
            0.28244,
            477,
            0.28102,
            478,
            0.27992,
            479,
            0.27912,
            480,
            0.2786,
            481,
            0.27832,
            482,
            0.27818,
            483,
            0.27803,
            484,
            0.27775,
            485,
            0.2772,
            486,
            0.27628,
            487,
            0.27497,
            488,
            0.27328,
            489,
            0.27122,
            490,
            0.2688,
            491,
            0.266,
            492,
            0.2627,
            493,
            0.25878,
            494,
            0.25409,
            495,
            0.2485,
            496,
            0.24193,
            497,
            0.23452,
            498,
            0.22648,
            499,
            0.218,
            500,
            0.2093,
            501,
            0.20053,
            502,
            0.19174,
            503,
            0.18292,
            504,
            0.17407,
            505,
            0.1652,
            506,
            0.15631,
            507,
            0.14743,
            508,
            0.13858,
            509,
            0.12979,
            510,
            0.1211,
            511,
            0.11254,
            512,
            0.10419,
            513,
            0.09612,
            514,
            0.08843,
            515,
            0.0812,
            516,
            0.07449,
            517,
            0.0683,
            518,
            0.06259,
            519,
            0.05733,
            520,
            0.0525,
            521,
            0.04806,
            522,
            0.04395,
            523,
            0.0401,
            524,
            0.03644,
            525,
            0.0329,
            526,
            0.02944,
            527,
            0.0261,
            528,
            0.02295,
            529,
            0.02006,
            530,
            0.0175,
            531,
            0.01531,
            532,
            0.01345,
            533,
            0.01187,
            534,
            0.0105,
            535,
            0.00929,
            536,
            0.00818,
            537,
            0.00716,
            538,
            0.00622,
            539,
            0.00537,
            540,
            0.00459,
            541,
            0.00389,
            542,
            0.00325,
            543,
            0.00268,
            544,
            0.00215,
            545,
            0.00166,
            546,
            0.00121,
            547,
            0.00081,
            548,
            0.00046,
            549,
            0.00019,
            550,
            0,
            551,
            0,
            552,
            0,
            553,
            0,
            554,
            0,
            555,
            0,
            556,
            0,
            557,
            0,
            558,
            0,
            559,
            0,
            560,
            0,
            561,
            0,
            562,
            0,
            563,
            0,
            564,
            0,
            565,
            0,
            566,
            0,
            567,
            0,
            568,
            0,
            569,
            0,
            570,
            0,
            571,
            0,
            572,
            0,
            573,
            0,
            574,
            0,
            575,
            0,
            576,
            0,
            577,
            0,
            578,
            0,
            579,
            0,
            580,
            0,
            581,
            0,
            582,
            0,
            583,
            0,
            584,
            0,
            585,
            0,
            586,
            0,
            587,
            0,
            588,
            0,
            589,
            0,
            590,
            0,
            591,
            0,
            592,
            0,
            593,
            0,
            594,
            0,
            595,
            0,
            596,
            0,
            597,
            0,
            598,
            0,
            599,
            0,
            600,
            0,
            601,
            0,
            602,
            0,
            603,
            0,
            604,
            0,
            605,
            0,
            606,
            0,
            607,
            0,
            608,
            0,
            609,
            0,
            610,
            0,
            611,
            0,
            612,
            0,
            613,
            0,
            614,
            0,
            615,
            0,
            616,
            0,
            617,
            0,
            618,
            0,
            619,
            0,
            620,
            0,
            621,
            0,
            622,
            0,
            623,
            0,
            624,
            0,
            625,
            0,
            626,
            0,
            627,
            0,
            628,
            0,
            629,
            0,
            630,
            0,
            631,
            0,
            632,
            0,
            633,
            0,
            634,
            0,
            635,
            0,
            636,
            0,
            637,
            0,
            638,
            0,
            639,
            0,
            640,
            0,
            641,
            0,
            642,
            0,
            643,
            0,
            644,
            0,
            645,
            0,
            646,
            0,
            647,
            0,
            648,
            0,
            649,
            0,
            650,
            0,
            651,
            0,
            652,
            0,
            653,
            0,
            654,
            0,
            655,
            0,
            656,
            0,
            657,
            0,
            658,
            0,
            659,
            0,
            660,
            0,
            661,
            0,
            662,
            0,
            663,
            0,
            664,
            0,
            665,
            0,
            666,
            0,
            667,
            0,
            668,
            0,
            669,
            0,
            670,
            0,
            671,
            0,
            672,
            0,
            673,
            0,
            674,
            0,
            675,
            0,
            676,
            0,
            677,
            0,
            678,
            0,
            679,
            0,
            680,
            0,
            681,
            0,
            682,
            0,
            683,
            0,
            684,
            0,
            685,
            0,
            686,
            0,
            687,
            0,
            688,
            0,
            689,
            0,
            690,
            0,
            691,
            0,
            692,
            0,
            693,
            0,
            694,
            0,
            695,
            0,
            696,
            0,
            697,
            0,
            698,
            0,
            699,
            0,
            700,
            0,
            701,
            0,
            702,
            0,
            703,
            0,
            704,
            0,
            705,
            0,
            706,
            0,
            707,
            0,
            708,
            0,
            709,
            0,
            710,
            0,
            711,
            0,
            712,
            0,
            713,
            0,
            714,
            0,
            715,
            0,
            716,
            0,
            717,
            0,
            718,
            0,
            719,
            0,
            720,
            0,
            721,
            0,
            722,
            0,
            723,
            0,
            724,
            0,
            725,
            0,
            726,
            0,
            727,
            0,
            728,
            0,
            729,
            0,
            730,
            0,
            731,
            0,
            732,
            0,
            733,
            0,
            734,
            0,
            735,
            0,
            736,
            0,
            737,
            0,
            738,
            0,
            739,
            0,
            740,
            0,
            741,
            0,
            742,
            0,
            743,
            0,
            744,
            0,
            745,
            0,
            746,
            0,
            747,
            0,
            748,
            0,
            749,
            0,
            750,
            0,
            751,
            0,
            752,
            0,
            753,
            0,
            754,
            0,
            755,
            0,
            756,
            0,
            757,
            0,
            758,
            0,
            759,
            0,
            760,
            0,
            761,
            0,
            762,
            0,
            763,
            0,
            764,
            0,
            765,
            0,
            766,
            0,
            767,
            0,
            768,
            0,
            769,
            0,
            770,
            0,
            771,
            0,
            772,
            0,
            773,
            0,
            774,
            0,
            775,
            0,
            776,
            0,
            777,
            0,
            778,
            0,
            779,
            0,
            780,
            0,
            781,
            0,
            782,
            0,
            783,
            0,
            784,
            0,
            785,
            0,
            786,
            0,
            787,
            0,
            788,
            0,
            789,
            0,
            790,
            0,
            791,
            0,
            792,
            0,
            793,
            0,
            794,
            0,
            795,
            0,
            796,
            0,
            797,
            0,
            798,
            0,
            799,
            0,
            800,
            0,
            801,
            0,
            802,
            0,
            803,
            0,
            804,
            0,
            805,
            0,
            806,
            0,
            807,
            0,
            808,
            0,
            809,
            0,
            810,
            0,
            811,
            0,
            812,
            0,
            813,
            0,
            814,
            0,
            815,
            0,
            816,
            0,
            817,
            0,
            818,
            0,
            819,
            0,
            820,
            0,
            821,
            0,
            822,
            0,
            823,
            0,
            824,
            0,
            825,
            0,
            826,
            0,
            827,
            0,
            828,
            0,
            829,
            0,
            830,
            0,
        ]
    )
    density = density.reshape(441, 2).astype(np.float64).T
    if trim_visible:
        prepend = np.array([[wl, np.nan] for wl in range(380, 390)])
        density = np.vstack((prepend, density.T))
        density = density[density[:, 0] < 781].T
    density = density[:, ::binwidth]
    if asdf:
        density = pd.Series(density[1], index=density[0], name=colnames[1])
        density.index.name = colnames[0]
    return density
