"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Support = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
 *
 * @experimental
 */
class Support extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [support](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupport.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'support';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AddAttachmentsToSet",
                "AddCommunicationToCase",
                "CreateCase",
                "InitiateCallForCase",
                "InitiateChatForCase",
                "PutCaseAttributes",
                "RateCaseCommunication",
                "RefreshTrustedAdvisorCheck",
                "ResolveCase"
            ],
            "Read": [
                "DescribeAttachment",
                "DescribeCaseAttributes",
                "DescribeCases",
                "DescribeCommunications",
                "DescribeIssueTypes",
                "DescribeServices",
                "DescribeSeverityLevels",
                "DescribeSupportLevel",
                "DescribeTrustedAdvisorCheckRefreshStatuses",
                "DescribeTrustedAdvisorCheckResult",
                "DescribeTrustedAdvisorCheckSummaries",
                "DescribeTrustedAdvisorChecks",
                "SearchForCases"
            ]
        };
    }
    /**
     * (experimental) Adds one or more attachments to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddAttachmentsToSet.html
     *
     * @experimental
     */
    toAddAttachmentsToSet() {
        return this.to('AddAttachmentsToSet');
    }
    /**
     * (experimental) Adds a customer communication to an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_AddCommunicationToCase.html
     *
     * @experimental
     */
    toAddCommunicationToCase() {
        return this.to('AddCommunicationToCase');
    }
    /**
     * (experimental) Creates a new AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CreateCase.html
     *
     * @experimental
     */
    toCreateCase() {
        return this.to('CreateCase');
    }
    /**
     * (experimental) Returns the description for an attachment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeAttachment.html
     *
     * @experimental
     */
    toDescribeAttachment() {
        return this.to('DescribeAttachment');
    }
    /**
     * (experimental) This is an internally managed function which allows secondary services to read AWS Support case attributes.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeCaseAttributes() {
        return this.to('DescribeCaseAttributes');
    }
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCases.html
     *
     * @experimental
     */
    toDescribeCases() {
        return this.to('DescribeCases');
    }
    /**
     * (experimental) Returns the communications and attachments for one or more AWS Support cases.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeCommunications.html
     *
     * @experimental
     */
    toDescribeCommunications() {
        return this.to('DescribeCommunications');
    }
    /**
     * (experimental) Returns issue types for AWS Support cases.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeIssueTypes() {
        return this.to('DescribeIssueTypes');
    }
    /**
     * (experimental) Returns the current list of AWS services and categories that applies to each service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeServices.html
     *
     * @experimental
     */
    toDescribeServices() {
        return this.to('DescribeServices');
    }
    /**
     * (experimental) Returns the list of severity levels that can be assigned to an AWS Support case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeSeverityLevels.html
     *
     * @experimental
     */
    toDescribeSeverityLevels() {
        return this.to('DescribeSeverityLevels');
    }
    /**
     * (experimental) Returns the support level for an AWS Account identifier.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toDescribeSupportLevel() {
        return this.to('DescribeSupportLevel');
    }
    /**
     * (experimental) Returns the status of a Trusted Advisor refresh check based on a list of check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckRefreshStatuses.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckRefreshStatuses() {
        return this.to('DescribeTrustedAdvisorCheckRefreshStatuses');
    }
    /**
     * (experimental) Returns the results of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckResult.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckResult() {
        return this.to('DescribeTrustedAdvisorCheckResult');
    }
    /**
     * (experimental) Returns the summaries of the results of the Trusted Advisor checks that have the specified check identifiers.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorCheckSummaries.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorCheckSummaries() {
        return this.to('DescribeTrustedAdvisorCheckSummaries');
    }
    /**
     * (experimental) Returns a list of all available Trusted Advisor checks, including name, identifier, category and description.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_DescribeTrustedAdvisorChecks.html
     *
     * @experimental
     */
    toDescribeTrustedAdvisorChecks() {
        return this.to('DescribeTrustedAdvisorChecks');
    }
    /**
     * (experimental) This is an internally managed function to initiate a call on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateCallForCase() {
        return this.to('InitiateCallForCase');
    }
    /**
     * (experimental) This is an internally managed function to initiate a chat on AWS Support Center.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toInitiateChatForCase() {
        return this.to('InitiateChatForCase');
    }
    /**
     * (experimental) This is an internally managed function which allows secondary services to attach attributes to AWS Support cases.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutCaseAttributes() {
        return this.to('PutCaseAttributes');
    }
    /**
     * (experimental) Rate an AWS Support case communication.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toRateCaseCommunication() {
        return this.to('RateCaseCommunication');
    }
    /**
     * (experimental) Requests a refresh of the Trusted Advisor check that has the specified check identifier.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_RefreshTrustedAdvisorCheck.html
     *
     * @experimental
     */
    toRefreshTrustedAdvisorCheck() {
        return this.to('RefreshTrustedAdvisorCheck');
    }
    /**
     * (experimental) Resolves an AWS Support case.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_ResolveCase.html
     *
     * @experimental
     */
    toResolveCase() {
        return this.to('ResolveCase');
    }
    /**
     * (experimental) Returns a list of AWS Support cases that matches the given inputs.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toSearchForCases() {
        return this.to('SearchForCases');
    }
}
exports.Support = Support;
_a = JSII_RTTI_SYMBOL_1;
Support[_a] = { fqn: "iam-floyd.Support", version: "0.203.0" };
//# sourceMappingURL=data:application/json;base64,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